/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authorization;

import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.AuthorizationHandlerImpl;
import java.util.List;
import org.apache.cassandra.sidecar.acl.AdminIdentityResolver;
import org.apache.cassandra.sidecar.acl.authorization.AuthorizationParameterValidateHandler;
import org.apache.cassandra.sidecar.utils.AuthUtils;

public class AuthorizationWithAdminBypassHandler
extends AuthorizationHandlerImpl {
    private final AuthorizationParameterValidateHandler authZParameterValidateHandler;
    private final AdminIdentityResolver adminIdentityResolver;

    public AuthorizationWithAdminBypassHandler(AuthorizationParameterValidateHandler authZParameterValidateHandler, AdminIdentityResolver adminIdentityResolver, Authorization authorization) {
        super(authorization);
        this.authZParameterValidateHandler = authZParameterValidateHandler;
        this.adminIdentityResolver = adminIdentityResolver;
    }

    public void handle(RoutingContext ctx) {
        this.authZParameterValidateHandler.handle(ctx);
        if (ctx.failed()) {
            return;
        }
        List<String> identities = AuthUtils.extractIdentities(ctx.user());
        if (!identities.isEmpty()) {
            if (identities.stream().anyMatch(this.adminIdentityResolver::isAdmin)) {
                ctx.next();
                return;
            }
        }
        super.handle(ctx);
    }
}

