/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authentication;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.sidecar.acl.authentication.AuthenticationHandlerFactory;

public class AuthenticationHandlerFactoryRegistry {
    private final Map<String, AuthenticationHandlerFactory> registry = new ConcurrentHashMap<String, AuthenticationHandlerFactory>();

    public void register(AuthenticationHandlerFactory factory) {
        Objects.requireNonNull(factory, "Factory must be non-null");
        this.registry.put(factory.getClass().getName(), factory);
    }

    public AuthenticationHandlerFactory getFactory(String className) {
        return this.registry.get(className);
    }
}

