/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.util;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Supplier;

public class PhysicalCoreExecutor {
    private static final int physicalCoreCount = Integer.getInteger("jvector.physical_core_count", Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
    public static final PhysicalCoreExecutor instance = new PhysicalCoreExecutor(physicalCoreCount);
    private final ForkJoinPool pool;

    private PhysicalCoreExecutor(int cores) {
        assert (cores > 0 && cores <= Runtime.getRuntime().availableProcessors()) : "Invalid core count: " + cores;
        this.pool = new ForkJoinPool(cores);
    }

    public void execute(Runnable run) {
        ((ForkJoinTask)this.pool.submit(run)).join();
    }

    public <T> T submit(Supplier<T> run) {
        return (T)((ForkJoinTask)this.pool.submit(run::get)).join();
    }
}

