/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.EvpKey;
import com.amazon.corretto.crypto.provider.EvpRsaKey;
import com.amazon.corretto.crypto.provider.EvpRsaPrivateKey;
import com.amazon.corretto.crypto.provider.EvpRsaPublicKey;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;

class EvpRsaPrivateCrtKey
extends EvpRsaPrivateKey
implements RSAPrivateCrtKey,
EvpKey.CanDerivePublicKey<EvpRsaPublicKey> {
    private static final long serialVersionUID = 1L;
    protected volatile BigInteger crtCoef;
    protected volatile BigInteger expP;
    protected volatile BigInteger expQ;
    protected volatile BigInteger primeP;
    protected volatile BigInteger primeQ;
    protected volatile BigInteger publicExponent;

    protected static native void getCrtParams(long var0, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8);

    protected static native boolean hasCrtParams(long var0);

    protected static EvpRsaPrivateKey buildProperKey(long l) {
        EvpRsaPrivateKey evpRsaPrivateKey = new EvpRsaPrivateCrtKey(l);
        if (!evpRsaPrivateKey.use(EvpRsaPrivateCrtKey::hasCrtParams).booleanValue()) {
            evpRsaPrivateKey = new EvpRsaPrivateKey(evpRsaPrivateKey.internalKey);
        }
        return evpRsaPrivateKey;
    }

    EvpRsaPrivateCrtKey(long l) {
        super(new EvpKey.InternalKey(l));
    }

    @Override
    public EvpRsaPublicKey getPublicKey() {
        this.ephemeral = false;
        return new EvpRsaPublicKey(this.internalKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigInteger getPublicExponent() {
        BigInteger bigInteger = this.publicExponent;
        if (bigInteger == null) {
            EvpRsaPrivateCrtKey evpRsaPrivateCrtKey = this;
            synchronized (evpRsaPrivateCrtKey) {
                bigInteger = this.publicExponent;
                if (bigInteger == null) {
                    this.publicExponent = bigInteger = this.nativeBN(EvpRsaKey::getPublicExponent);
                }
            }
        }
        return bigInteger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initBNs() {
        if (this.privateExponent != null) {
            return;
        }
        EvpRsaPrivateCrtKey evpRsaPrivateCrtKey = this;
        synchronized (evpRsaPrivateCrtKey) {
            if (this.privateExponent != null) {
                return;
            }
            BigInteger bigInteger = this.getModulus();
            int n = (bigInteger.bitLength() + 7) / 8;
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            byte[] byArray4 = new byte[n];
            byte[] byArray5 = new byte[n];
            byte[] byArray6 = new byte[n];
            byte[] byArray7 = new byte[n];
            this.useVoid(l -> EvpRsaPrivateCrtKey.getCrtParams(l, byArray, byArray2, byArray3, byArray4, byArray5, byArray6, byArray7));
            this.crtCoef = new BigInteger(1, byArray);
            this.expP = new BigInteger(1, byArray2);
            this.expQ = new BigInteger(1, byArray3);
            this.primeP = new BigInteger(1, byArray4);
            this.primeQ = new BigInteger(1, byArray5);
            this.publicExponent = new BigInteger(1, byArray6);
            this.privateExponent = new BigInteger(1, byArray7);
        }
    }

    @Override
    public BigInteger getPrivateExponent() {
        this.initBNs();
        return this.privateExponent;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        this.initBNs();
        return this.crtCoef;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        this.initBNs();
        return this.expP;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        this.initBNs();
        return this.expQ;
    }

    @Override
    public BigInteger getPrimeP() {
        this.initBNs();
        return this.primeP;
    }

    @Override
    public BigInteger getPrimeQ() {
        this.initBNs();
        return this.primeQ;
    }

    @Override
    protected synchronized void destroyJavaState() {
        super.destroyJavaState();
        this.crtCoef = null;
        this.expP = null;
        this.expQ = null;
        this.primeP = null;
        this.primeQ = null;
        this.privateExponent = null;
    }
}

