/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedSet;

public class InsertionOrderedNavigableSet<E>
implements NavigableSet<E> {
    private final ArrayList<E> elements = new ArrayList();
    private final Comparator<? super E> comparator;

    public InsertionOrderedNavigableSet(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public E lower(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E floor(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E ceiling(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E higher(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E pollFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.elements.remove(0);
    }

    @Override
    public E pollLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.elements.remove(this.size() - 1);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.elements.toArray(a);
    }

    @Override
    public boolean add(E e) {
        if (!this.isEmpty() && this.comparator.compare(e, this.last()) <= 0) {
            throw new IllegalStateException("Cannot add element " + e + " as it is not greater than the current last element " + this.last());
        }
        return this.elements.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.elements.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E element : c) {
            if (!this.add(element)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.elements.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.elements.removeAll(c);
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> descendingIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        E element;
        int comparison;
        Preconditions.checkNotNull(toElement);
        if (this.isEmpty()) {
            return Collections.emptyNavigableSet();
        }
        InsertionOrderedNavigableSet<E> head = new InsertionOrderedNavigableSet<E>(this.comparator);
        Iterator<E> iterator = this.elements.iterator();
        while (iterator.hasNext() && (comparison = this.comparator.compare(element = iterator.next(), toElement)) <= 0 && (comparison != 0 || inclusive)) {
            head.add(element);
        }
        return head;
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        Preconditions.checkNotNull(fromElement);
        if (this.isEmpty()) {
            return Collections.emptyNavigableSet();
        }
        InsertionOrderedNavigableSet<E> tail = new InsertionOrderedNavigableSet<E>(this.comparator);
        for (E element : this.elements) {
            int comparison = this.comparator.compare(element, fromElement);
            if (comparison < 0 || comparison == 0 && !inclusive) continue;
            tail.add(element);
        }
        return tail;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, true);
    }

    @Override
    public E first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements.get(0);
    }

    @Override
    public E last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements.get(this.size() - 1);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertionOrderedNavigableSet that = (InsertionOrderedNavigableSet)o;
        return Objects.equals(this.elements, that.elements) && Objects.equals(this.comparator, that.comparator);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.elements, this.comparator);
    }
}

