/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.streaming.IncomingStream;
import org.apache.cassandra.streaming.OutgoingStream;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.messages.OutgoingStreamMessage;
import org.apache.cassandra.utils.FBUtilities;

public interface StreamHook {
    public static final StreamHook instance = StreamHook.createHook();

    public OutgoingStreamMessage reportOutgoingStream(StreamSession var1, OutgoingStream var2, OutgoingStreamMessage var3);

    public void reportStreamFuture(StreamSession var1, StreamResultFuture var2);

    public void reportIncomingStream(TableId var1, IncomingStream var2, StreamSession var3, int var4);

    public static StreamHook createHook() {
        String className = CassandraRelevantProperties.STREAM_HOOK.getString();
        if (className != null) {
            return (StreamHook)FBUtilities.construct(className, StreamHook.class.getSimpleName());
        }
        return new StreamHook(){

            @Override
            public OutgoingStreamMessage reportOutgoingStream(StreamSession session, OutgoingStream stream, OutgoingStreamMessage message) {
                return message;
            }

            @Override
            public void reportStreamFuture(StreamSession session, StreamResultFuture future) {
            }

            @Override
            public void reportIncomingStream(TableId tableId, IncomingStream stream, StreamSession session, int sequenceNumber) {
            }
        };
    }
}

