/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.security;

import java.io.IOException;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.security.FileBasedSslContextFactory;
import org.apache.cassandra.security.PEMReader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PEMBasedSslContextFactory
extends FileBasedSslContextFactory {
    public static final String DEFAULT_TARGET_STORETYPE = "PKCS12";
    private static final Logger logger = LoggerFactory.getLogger(PEMBasedSslContextFactory.class);
    private PEMBasedKeyStoreContext pemEncodedTrustCertificates;
    private PEMBasedKeyStoreContext pemEncodedKeyContext;
    private PEMBasedKeyStoreContext pemEncodedOutboundKeyContext;

    public PEMBasedSslContextFactory() {
    }

    private void validatePasswords() {
        String keyName;
        boolean shouldThrow = !this.keystoreContext.passwordMatchesIfPresent(this.pemEncodedKeyContext.password) || !this.outboundKeystoreContext.passwordMatchesIfPresent(this.pemEncodedOutboundKeyContext.password);
        boolean outboundPasswordMismatch = !this.outboundKeystoreContext.passwordMatchesIfPresent(this.pemEncodedOutboundKeyContext.password);
        String string = keyName = outboundPasswordMismatch ? "outbound_" : "";
        if (shouldThrow) {
            String msg = String.format("'%skeystore_password' and '%skey_password' both configurations are given and the values do not match", keyName, keyName);
            throw new IllegalArgumentException(msg);
        }
    }

    public PEMBasedSslContextFactory(Map<String, Object> parameters) {
        super(parameters);
        String pemEncodedKey = this.getString(ConfigKey.ENCODED_KEY.getKeyName());
        String pemEncodedKeyPassword = StringUtils.defaultString((String)this.getString(ConfigKey.KEY_PASSWORD.getKeyName()), (String)this.keystoreContext.password);
        this.pemEncodedKeyContext = new PEMBasedKeyStoreContext(pemEncodedKey, pemEncodedKeyPassword, StringUtils.isEmpty((CharSequence)pemEncodedKey), this.keystoreContext);
        String pemEncodedOutboundKey = StringUtils.defaultString((String)this.getString(ConfigKey.OUTBOUND_ENCODED_KEY.getKeyName()), (String)pemEncodedKey);
        String outboundKeyPassword = StringUtils.defaultString((String)StringUtils.defaultString((String)this.getString(ConfigKey.OUTBOUND_ENCODED_KEY_PASSWORD.getKeyName()), (String)this.outboundKeystoreContext.password), (String)pemEncodedKeyPassword);
        this.pemEncodedOutboundKeyContext = new PEMBasedKeyStoreContext(pemEncodedKey, outboundKeyPassword, StringUtils.isEmpty((CharSequence)pemEncodedOutboundKey), this.outboundKeystoreContext);
        this.validatePasswords();
        if (!StringUtils.isEmpty((CharSequence)this.trustStoreContext.password)) {
            logger.warn("PEM based truststore should not be using password. Ignoring the given value in 'truststore_password' configuration.");
        }
        String pemEncodedCerts = this.getString(ConfigKey.ENCODED_CERTIFICATES.getKeyName());
        this.pemEncodedTrustCertificates = new PEMBasedKeyStoreContext(pemEncodedCerts, null, StringUtils.isEmpty((CharSequence)pemEncodedCerts), this.trustStoreContext);
        this.enforceSinglePrivateKeySource();
        this.enforceSingleTurstedCertificatesSource();
    }

    @Override
    public boolean hasKeystore() {
        return this.pemEncodedKeyContext.maybeFilebasedKey ? this.keystoreContext.hasKeystore() : !StringUtils.isEmpty((CharSequence)this.pemEncodedKeyContext.key);
    }

    @Override
    public boolean hasOutboundKeystore() {
        return this.pemEncodedOutboundKeyContext.maybeFilebasedKey ? this.outboundKeystoreContext.hasKeystore() : !StringUtils.isEmpty((CharSequence)this.pemEncodedOutboundKeyContext.key);
    }

    private boolean hasTruststore() {
        return this.pemEncodedTrustCertificates.maybeFilebasedKey ? this.truststoreFileExists() : !StringUtils.isEmpty((CharSequence)this.pemEncodedTrustCertificates.key);
    }

    private boolean truststoreFileExists() {
        return this.trustStoreContext.filePath != null && new File(this.trustStoreContext.filePath).exists();
    }

    @Override
    public synchronized void initHotReloading() {
        ArrayList<FileBasedSslContextFactory.HotReloadableFile> fileList = new ArrayList<FileBasedSslContextFactory.HotReloadableFile>();
        if (this.pemEncodedKeyContext.maybeFilebasedKey && this.hasKeystore()) {
            fileList.add(new FileBasedSslContextFactory.HotReloadableFile(this.keystoreContext.filePath));
        }
        if (this.pemEncodedOutboundKeyContext.maybeFilebasedKey && this.hasOutboundKeystore()) {
            fileList.add(new FileBasedSslContextFactory.HotReloadableFile(this.outboundKeystoreContext.filePath));
        }
        if (this.pemEncodedTrustCertificates.maybeFilebasedKey && this.hasTruststore()) {
            fileList.add(new FileBasedSslContextFactory.HotReloadableFile(this.trustStoreContext.filePath));
        }
        if (!fileList.isEmpty()) {
            this.hotReloadableFiles = fileList;
        }
    }

    @Override
    protected KeyManagerFactory buildKeyManagerFactory() throws SSLException {
        return this.buildKeyManagerFactory(this.pemEncodedKeyContext, this.keystoreContext);
    }

    @Override
    protected KeyManagerFactory buildOutboundKeyManagerFactory() throws SSLException {
        return this.buildKeyManagerFactory(this.pemEncodedOutboundKeyContext, this.outboundKeystoreContext);
    }

    private KeyManagerFactory buildKeyManagerFactory(PEMBasedKeyStoreContext pemBasedKeyStoreContext, FileBasedSslContextFactory.FileBasedStoreContext keyStoreContext) throws SSLException {
        try {
            if (pemBasedKeyStoreContext.hasKey()) {
                if (pemBasedKeyStoreContext.maybeFilebasedKey) {
                    pemBasedKeyStoreContext.key = this.readPEMFile(keyStoreContext.filePath);
                }
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.algorithm == null ? KeyManagerFactory.getDefaultAlgorithm() : this.algorithm);
                KeyStore ks = PEMBasedSslContextFactory.buildKeyStore(pemBasedKeyStoreContext.key, pemBasedKeyStoreContext.password);
                if (!keyStoreContext.checkedExpiry) {
                    this.checkExpiredCerts(ks);
                    keyStoreContext.checkedExpiry = true;
                }
                kmf.init(ks, pemBasedKeyStoreContext.password != null ? pemBasedKeyStoreContext.password.toCharArray() : null);
                return kmf;
            }
            throw new SSLException("Must provide outbound_keystore or outbound_private_key in configuration for PEMBasedSSlContextFactory");
        }
        catch (Exception e) {
            throw new SSLException("Failed to build key manager store for secure connections", e);
        }
    }

    @Override
    protected TrustManagerFactory buildTrustManagerFactory() throws SSLException {
        try {
            if (this.hasTruststore()) {
                if (this.pemEncodedTrustCertificates.maybeFilebasedKey) {
                    this.pemEncodedTrustCertificates.key = this.readPEMFile(this.trustStoreContext.filePath);
                }
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.algorithm == null ? TrustManagerFactory.getDefaultAlgorithm() : this.algorithm);
                KeyStore ts = this.buildTrustStore();
                tmf.init(ts);
                return tmf;
            }
            throw new SSLException("Must provide truststore or trusted_certificates in configuration for PEMBasedSSlContextFactory");
        }
        catch (Exception e) {
            throw new SSLException("Failed to build trust manager store for secure connections", e);
        }
    }

    private String readPEMFile(String file) throws IOException {
        return new String(Files.readAllBytes(File.getPath(file, new String[0])));
    }

    private static KeyStore buildKeyStore(String pemEncodedKey, String keyPassword) throws GeneralSecurityException, IOException {
        char[] keyPasswordArray = keyPassword != null ? keyPassword.toCharArray() : null;
        PrivateKey privateKey = PEMReader.extractPrivateKey(pemEncodedKey, keyPassword);
        Certificate[] certChainArray = PEMReader.extractCertificates(pemEncodedKey);
        if (certChainArray == null || certChainArray.length == 0) {
            throw new SSLException("Could not read any certificates for the certChain for the private key");
        }
        KeyStore keyStore = KeyStore.getInstance(DEFAULT_TARGET_STORETYPE);
        keyStore.load(null, null);
        keyStore.setKeyEntry("cassandra-ssl-keystore", privateKey, keyPasswordArray, certChainArray);
        return keyStore;
    }

    private KeyStore buildTrustStore() throws GeneralSecurityException, IOException {
        Certificate[] certChainArray = PEMReader.extractCertificates(this.pemEncodedTrustCertificates.key);
        if (certChainArray == null || certChainArray.length == 0) {
            throw new SSLException("Could not read any certificates from the given PEM");
        }
        KeyStore keyStore = KeyStore.getInstance(DEFAULT_TARGET_STORETYPE);
        keyStore.load(null, null);
        for (int i = 0; i < certChainArray.length; ++i) {
            keyStore.setCertificateEntry("cassandra-ssl-trusted-cert-" + (i + 1), certChainArray[i]);
        }
        return keyStore;
    }

    private void enforceSinglePrivateKeySource() {
        if (this.keystoreContext.hasKeystore() && !StringUtils.isEmpty((CharSequence)this.pemEncodedKeyContext.key)) {
            throw new IllegalArgumentException("Configuration must specify value for either keystore or private_key, not both for PEMBasedSSlContextFactory");
        }
        if (this.outboundKeystoreContext.hasKeystore() && !StringUtils.isEmpty((CharSequence)this.pemEncodedOutboundKeyContext.key)) {
            throw new IllegalArgumentException("Configuration must specify value for either outbound_keystore or outbound_private_key, not both for PEMBasedSSlContextFactory");
        }
    }

    private void enforceSingleTurstedCertificatesSource() {
        if (this.truststoreFileExists() && !StringUtils.isEmpty((CharSequence)this.pemEncodedTrustCertificates.key)) {
            throw new IllegalArgumentException("Configuration must specify value for either truststore or trusted_certificates, not both for PEMBasedSSlContextFactory");
        }
    }

    public static enum ConfigKey {
        ENCODED_KEY("private_key"),
        KEY_PASSWORD("private_key_password"),
        OUTBOUND_ENCODED_KEY("outbound_private_key"),
        OUTBOUND_ENCODED_KEY_PASSWORD("outbound_private_key_password"),
        ENCODED_CERTIFICATES("trusted_certificates");

        final String keyName;

        private ConfigKey(String keyName) {
            this.keyName = keyName;
        }

        String getKeyName() {
            return this.keyName;
        }
    }

    public static class PEMBasedKeyStoreContext {
        public String key;
        public final String password;
        public final boolean maybeFilebasedKey;
        public final FileBasedSslContextFactory.FileBasedStoreContext filebasedKeystoreContext;

        public PEMBasedKeyStoreContext(String encodedKey, String getEncodedKeyPassword, boolean maybeFilebasedKey, FileBasedSslContextFactory.FileBasedStoreContext filebasedKeystoreContext) {
            this.key = encodedKey;
            this.password = getEncodedKeyPassword;
            this.maybeFilebasedKey = maybeFilebasedKey;
            this.filebasedKeystoreContext = filebasedKeystoreContext;
        }

        public boolean hasKey() {
            return this.maybeFilebasedKey ? this.filebasedKeystoreContext.hasKeystore() : !StringUtils.isEmpty((CharSequence)this.key);
        }
    }
}

