/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.memory;

import java.util.SortedSet;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.index.sai.memory.InMemoryKeyRangeIterator;
import org.apache.cassandra.index.sai.utils.PrimaryKey;

public class FilteringInMemoryKeyRangeIterator
extends InMemoryKeyRangeIterator {
    private final AbstractBounds<PartitionPosition> keyRange;

    public FilteringInMemoryKeyRangeIterator(SortedSet<PrimaryKey> keys, AbstractBounds<PartitionPosition> keyRange) {
        super(keys);
        this.keyRange = keyRange;
    }

    @Override
    protected PrimaryKey computeNext() {
        PrimaryKey key = this.computeNextKey();
        while (key != null && !this.keyRange.contains(key.partitionKey())) {
            key = this.computeNextKey();
        }
        return key == null ? (PrimaryKey)this.endOfData() : key;
    }
}

