/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.iterators;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyRangeIntersectionIterator
extends KeyRangeIterator {
    private static final Logger logger = LoggerFactory.getLogger(KeyRangeIntersectionIterator.class);
    private final List<KeyRangeIterator> ranges;
    private PrimaryKey highestKey;

    private KeyRangeIntersectionIterator(KeyRangeIterator.Builder.Statistics statistics, List<KeyRangeIterator> ranges, Runnable onClose) {
        super(statistics, onClose);
        this.ranges = ranges;
        this.highestKey = null;
    }

    @Override
    protected PrimaryKey computeNext() {
        if (this.highestKey == null) {
            this.highestKey = this.computeHighestKey();
        }
        block0: while (this.highestKey != null && this.highestKey.compareTo(this.getMaximum(), false) <= 0) {
            for (KeyRangeIterator range : this.ranges) {
                if (!range.hasNext()) {
                    return (PrimaryKey)this.endOfData();
                }
                if (((PrimaryKey)range.peek()).compareTo(this.highestKey, false) >= 0) continue;
                PrimaryKey nextKey = this.skipToHighestKey(range);
                if (nextKey == null || nextKey.compareTo(this.highestKey, true) > 0) {
                    this.highestKey = nextKey;
                    continue block0;
                }
                assert (nextKey.compareTo(this.highestKey, false) == 0) : String.format("Skipped to a key smaller than the target! iterator: %s, target key: %s, returned key: %s", range, this.highestKey, nextKey);
            }
            PrimaryKey result = this.highestKey;
            this.highestKey = this.advanceOneRange();
            return result;
        }
        return (PrimaryKey)this.endOfData();
    }

    private PrimaryKey skipToHighestKey(KeyRangeIterator range) {
        if (((PrimaryKey)range.peek()).kind() == this.highestKey.kind()) {
            return this.skipAndPeek(range, this.highestKey);
        }
        if (((PrimaryKey)range.peek()).kind() == PrimaryKey.Kind.STATIC) {
            PrimaryKey nextKey = this.skipAndPeek(range, this.highestKey.toStatic());
            if (nextKey != null && nextKey.compareTo(this.highestKey, true) < 0 && nextKey.kind() == PrimaryKey.Kind.WIDE) {
                nextKey = this.skipAndPeek(range, this.highestKey);
            }
            return nextKey;
        }
        return this.skipAndPeek(range, this.highestKey);
    }

    @Nullable
    private PrimaryKey advanceOneRange() {
        for (KeyRangeIterator range : this.ranges) {
            if (((PrimaryKey)range.peek()).kind() == PrimaryKey.Kind.STATIC) continue;
            range.next();
            return range.hasNext() ? (PrimaryKey)range.peek() : null;
        }
        for (KeyRangeIterator range : this.ranges) {
            if (((PrimaryKey)range.peek()).kind() != PrimaryKey.Kind.STATIC) continue;
            range.next();
            return range.hasNext() ? (PrimaryKey)range.peek() : null;
        }
        throw new IllegalStateException("There should be at least one range to advance!");
    }

    @Nullable
    private PrimaryKey computeHighestKey() {
        PrimaryKey max = this.getMinimum();
        for (KeyRangeIterator range : this.ranges) {
            if (!range.hasNext()) {
                return null;
            }
            if (((PrimaryKey)range.peek()).compareTo(max, true) <= 0) continue;
            max = (PrimaryKey)range.peek();
        }
        return max;
    }

    @Override
    protected void performSkipTo(PrimaryKey nextKey) {
        for (KeyRangeIterator range : this.ranges) {
            range.skipTo(nextKey);
        }
        this.highestKey = null;
    }

    @Override
    public void close() {
        super.close();
        FileUtils.closeQuietly(this.ranges);
    }

    private PrimaryKey skipAndPeek(KeyRangeIterator iterator, PrimaryKey minKey) {
        iterator.skipTo(minKey);
        return iterator.hasNext() ? (PrimaryKey)iterator.peek() : null;
    }

    public static Builder builder(int size, int limit) {
        return KeyRangeIntersectionIterator.builder(size, limit, () -> {});
    }

    public static Builder builder(int size, Runnable onClose) {
        return new Builder(size, onClose);
    }

    @VisibleForTesting
    public static Builder builder(int size, int limit, Runnable onClose) {
        return new Builder(size, limit, onClose);
    }

    @VisibleForTesting
    protected static boolean isDisjoint(KeyRangeIterator a, KeyRangeIterator b) {
        return KeyRangeIntersectionIterator.isDisjointInternal((PrimaryKey)a.peek(), a.getMaximum(), b);
    }

    private static boolean isDisjointInternal(PrimaryKey min, PrimaryKey max, KeyRangeIterator b) {
        return min == null || max == null || b.getMaxKeys() == 0L || min.compareTo(b.getMaximum(), false) > 0 || b.hasNext() && ((PrimaryKey)b.peek()).compareTo(max, false) > 0;
    }

    static {
        logger.info(String.format("Storage attached index intersection clause limit is %d", CassandraRelevantProperties.SAI_INTERSECTION_CLAUSE_LIMIT.getInt()));
    }

    private static class IntersectionStatistics
    extends KeyRangeIterator.Builder.Statistics {
        private boolean empty = true;

        private IntersectionStatistics() {
        }

        @Override
        public void update(KeyRangeIterator range) {
            this.min = KeyRangeIterator.nullSafeMax(this.min, range.getMinimum());
            this.max = KeyRangeIterator.nullSafeMin(this.max, range.getMaximum());
            this.min = KeyRangeIterator.nullSafeMin(this.min, this.max);
            if (this.empty) {
                this.empty = false;
                this.count = range.getMaxKeys();
            } else {
                this.count = Math.min(this.count, range.getMaxKeys());
            }
        }
    }

    @VisibleForTesting
    public static class Builder
    extends KeyRangeIterator.Builder {
        private final int limit;
        private boolean isDisjoint;
        protected final List<KeyRangeIterator> rangeIterators;

        Builder(int size, Runnable onClose) {
            this(size, CassandraRelevantProperties.SAI_INTERSECTION_CLAUSE_LIMIT.getInt(), onClose);
        }

        Builder(int size, int limit, Runnable onClose) {
            super(new IntersectionStatistics(), onClose);
            this.rangeIterators = new ArrayList<KeyRangeIterator>(size);
            this.limit = limit;
        }

        @Override
        public KeyRangeIterator.Builder add(KeyRangeIterator range) {
            if (range == null) {
                return this;
            }
            if (range.getMaxKeys() > 0L) {
                this.rangeIterators.add(range);
            } else {
                FileUtils.closeQuietly(range);
            }
            this.updateStatistics(this.statistics, range);
            return this;
        }

        @Override
        public int rangeCount() {
            return this.rangeIterators.size();
        }

        @Override
        public void cleanup() {
            super.cleanup();
            FileUtils.closeQuietly(this.rangeIterators);
        }

        @Override
        protected KeyRangeIterator buildIterator() {
            this.rangeIterators.sort(Comparator.comparingLong(KeyRangeIterator::getMaxKeys));
            int initialSize = this.rangeIterators.size();
            if (this.limit >= this.rangeIterators.size() || this.limit <= 0) {
                return this.buildIterator(this.statistics, this.rangeIterators);
            }
            IntersectionStatistics selectiveStatistics = new IntersectionStatistics();
            this.isDisjoint = false;
            for (int i = this.rangeIterators.size() - 1; i >= 0 && i >= this.limit; --i) {
                FileUtils.closeQuietly(this.rangeIterators.remove(i));
            }
            this.rangeIterators.forEach(range -> this.updateStatistics(selectiveStatistics, (KeyRangeIterator)range));
            if (Tracing.isTracing()) {
                Tracing.trace("Selecting {} {} of {} out of {} indexes", this.rangeIterators.size(), this.rangeIterators.size() > 1 ? "indexes with cardinalities" : "index with cardinality", this.rangeIterators.stream().map(KeyRangeIterator::getMaxKeys).map(Object::toString).collect(Collectors.joining(", ")), initialSize);
            }
            return this.buildIterator(selectiveStatistics, this.rangeIterators);
        }

        public boolean isDisjoint() {
            return this.isDisjoint;
        }

        private KeyRangeIterator buildIterator(KeyRangeIterator.Builder.Statistics statistics, List<KeyRangeIterator> ranges) {
            if (this.isDisjoint) {
                FileUtils.closeQuietly(ranges);
                this.onClose.run();
                return KeyRangeIterator.empty();
            }
            if (ranges.size() == 1) {
                KeyRangeIterator single = ranges.get(0);
                single.setOnClose(this.onClose);
                return single;
            }
            PrimaryKey.Kind firstKind = null;
            for (KeyRangeIterator range : ranges) {
                PrimaryKey key = range.hasNext() ? (PrimaryKey)range.peek() : range.getMaximum();
                if (key == null) continue;
                if (firstKind == null) {
                    firstKind = key.kind();
                    continue;
                }
                if (firstKind.isIntersectable(key.kind())) continue;
                throw new IllegalArgumentException("Cannot intersect " + firstKind + " and " + key.kind() + " ranges!");
            }
            return new KeyRangeIntersectionIterator(statistics, ranges, this.onClose);
        }

        private void updateStatistics(KeyRangeIterator.Builder.Statistics statistics, KeyRangeIterator range) {
            statistics.update(range);
            this.isDisjoint |= KeyRangeIntersectionIterator.isDisjointInternal(statistics.min, statistics.max, range);
        }
    }
}

