/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.analyzer.filter;

import java.text.Normalizer;
import java.util.Locale;
import org.apache.cassandra.index.sai.analyzer.filter.FilterPipeline;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;

public class BasicFilters {
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();

    public static class NoOperation
    extends FilterPipeline.Task {
        @Override
        public String process(String input) {
            return input;
        }
    }

    public static class Ascii
    extends FilterPipeline.Task {
        @Override
        public String process(String input) {
            if (input == null) {
                return null;
            }
            char[] inputChars = input.toCharArray();
            char[] outputChars = new char[inputChars.length * 4];
            int outputSize = ASCIIFoldingFilter.foldToASCII((char[])inputChars, (int)0, (char[])outputChars, (int)0, (int)inputChars.length);
            return new String(outputChars, 0, outputSize);
        }
    }

    public static class Normalize
    extends FilterPipeline.Task {
        @Override
        public String process(String input) {
            if (input == null) {
                return null;
            }
            return Normalizer.isNormalized(input, Normalizer.Form.NFC) ? input : Normalizer.normalize(input, Normalizer.Form.NFC);
        }
    }

    public static class LowerCase
    extends FilterPipeline.Task {
        private final Locale locale = DEFAULT_LOCALE;

        @Override
        public String process(String input) {
            return input.toLowerCase(this.locale);
        }
    }
}

