/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.diag.store;

import com.google.common.annotations.VisibleForTesting;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.diag.DiagnosticEvent;
import org.apache.cassandra.diag.store.DiagnosticEventStore;

public final class DiagnosticEventMemoryStore
implements DiagnosticEventStore<Long> {
    private final AtomicLong lastKey = new AtomicLong(0L);
    private int maxSize = 200;
    private final ConcurrentSkipListMap<Long, DiagnosticEvent> events = new ConcurrentSkipListMap(Comparator.reverseOrder());

    @Override
    public void load() {
    }

    @Override
    public void store(DiagnosticEvent event) {
        long keyHead = this.lastKey.incrementAndGet();
        this.events.put(keyHead, event);
        if (keyHead > (long)this.maxSize) {
            this.events.tailMap((Object)(keyHead - (long)this.maxSize)).clear();
        }
    }

    @Override
    public NavigableMap<Long, DiagnosticEvent> scan(Long id, int limit) {
        assert (id != null && id >= 0L);
        assert (limit >= 0);
        NavigableMap newerEvents = this.events.headMap((Object)id, true);
        NavigableMap ret = newerEvents.descendingMap();
        if (limit == 0) {
            return ret;
        }
        Map.Entry first = ret.firstEntry();
        if (first == null) {
            return ret;
        }
        return ret.headMap((Object)((Long)first.getKey() + (long)limit));
    }

    @Override
    public Long getLastEventId() {
        return this.lastKey.get();
    }

    @VisibleForTesting
    int size() {
        return this.events.size();
    }

    @VisibleForTesting
    void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
}

