/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewBuilderTask
extends CompactionInfo.Holder
implements Callable<Long> {
    private static final Logger logger = LoggerFactory.getLogger(ViewBuilderTask.class);
    private static final int ROWS_BETWEEN_CHECKPOINTS = 1000;
    private final ColumnFamilyStore baseCfs;
    private final View view;
    private final Range<Token> range;
    private final TimeUUID compactionId;
    private volatile Token prevToken;
    private volatile long keysBuilt = 0L;
    private volatile boolean isStopped = false;
    private volatile boolean isCompactionInterrupted = false;

    @VisibleForTesting
    public ViewBuilderTask(ColumnFamilyStore baseCfs, View view, Range<Token> range, Token lastToken, long keysBuilt) {
        this.baseCfs = baseCfs;
        this.view = view;
        this.range = range;
        this.compactionId = TimeUUID.Generator.nextTimeUUID();
        this.prevToken = lastToken;
        this.keysBuilt = keysBuilt;
    }

    private void buildKey(DecoratedKey key) {
        ReadQuery selectQuery = this.view.getReadQuery();
        if (!selectQuery.selectsKey(key)) {
            logger.trace("Skipping {}, view query filters", (Object)key);
            return;
        }
        long nowInSec = FBUtilities.nowInSeconds();
        SinglePartitionReadCommand command = this.view.getSelectStatement().internalReadForView(key, nowInSec);
        UnfilteredRowIterator empty = UnfilteredRowIterators.noRowsIterator(this.baseCfs.metadata(), key, Rows.EMPTY_STATIC_ROW, DeletionTime.LIVE, false);
        try (ReadExecutionController orderGroup = command.executionController();
             UnfilteredRowIterator data = UnfilteredPartitionIterators.getOnlyElement(command.executeLocally(orderGroup), command);){
            Iterator<Collection<Mutation>> mutations = this.baseCfs.keyspace.viewManager.forTable(this.baseCfs.metadata.id).generateViewUpdates(Collections.singleton(this.view), data, empty, nowInSec, true);
            AtomicLong noBase = new AtomicLong(Long.MAX_VALUE);
            mutations.forEachRemaining(m -> StorageProxy.mutateMV(key.getKey(), m, true, noBase, Dispatcher.RequestTime.forImmediateExecution()));
        }
    }

    @Override
    public Long call() {
        String ksName = this.baseCfs.metadata.keyspace;
        if (this.prevToken == null) {
            logger.debug("Starting new view build for range {}", this.range);
        } else {
            logger.debug("Resuming view build for range {} from token {} with {} covered keys", new Object[]{this.range, this.prevToken, this.keysBuilt});
        }
        boolean schemaConverged = Gossiper.instance.waitForSchemaAgreement(10L, TimeUnit.SECONDS, () -> this.isStopped);
        if (!schemaConverged) {
            logger.warn("Failed to get schema to converge before building view {}.{}", (Object)this.baseCfs.getKeyspaceName(), (Object)this.view.name);
        }
        Function<org.apache.cassandra.db.lifecycle.View, Iterable<SSTableReader>> function = org.apache.cassandra.db.lifecycle.View.select(SSTableSet.CANONICAL, (Predicate<SSTableReader>)((Predicate)s -> this.range.intersects(s.getBounds())));
        try (ColumnFamilyStore.RefViewFragment viewFragment = this.baseCfs.selectAndReference(function);
             Refs<SSTableReader> sstables = viewFragment.refs;
             ReducingKeyIterator keyIter = new ReducingKeyIterator(sstables);){
            PeekingIterator iter = Iterators.peekingIterator((Iterator)keyIter);
            while (!this.isStopped && iter.hasNext()) {
                DecoratedKey key = (DecoratedKey)iter.next();
                Token token = key.getToken();
                if (!this.range.contains(token) || this.prevToken != null && token.compareTo(this.prevToken) <= 0) continue;
                this.buildKey(key);
                ++this.keysBuilt;
                while (iter.hasNext() && ((DecoratedKey)iter.peek()).getToken().equals(token)) {
                    key = (DecoratedKey)iter.next();
                    this.buildKey(key);
                    ++this.keysBuilt;
                }
                if (this.keysBuilt % 1000L == 1L) {
                    SystemKeyspace.updateViewBuildStatus(ksName, this.view.name, this.range, token, this.keysBuilt);
                }
                this.prevToken = token;
            }
        }
        this.finish();
        return this.keysBuilt;
    }

    private void finish() {
        String ksName = this.baseCfs.getKeyspaceName();
        if (!this.isStopped) {
            SystemKeyspace.updateViewBuildStatus(ksName, this.view.name, this.range, (Token)this.range.right, this.keysBuilt);
            logger.debug("Completed build of view({}.{}) for range {} after covering {} keys ", new Object[]{ksName, this.view.name, this.range, this.keysBuilt});
        } else {
            logger.debug("Stopped build for view({}.{}) for range {} after covering {} keys", new Object[]{ksName, this.view.name, this.range, this.keysBuilt});
            if (this.isCompactionInterrupted) {
                throw new StoppedException(ksName, this.view.name, this.getCompactionInfo());
            }
        }
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        if (((Token)this.range.left).getPartitioner().splitter().isPresent()) {
            long progress = this.prevToken == null ? 0L : Math.round(this.prevToken.getPartitioner().splitter().get().positionInRange(this.prevToken, this.range) * 1000.0);
            return CompactionInfo.withoutSSTables(this.baseCfs.metadata(), OperationType.VIEW_BUILD, progress, 1000L, CompactionInfo.Unit.RANGES, this.compactionId);
        }
        long keysTotal = Math.max(this.keysBuilt + 1L, this.baseCfs.estimatedKeysForRange(this.range));
        return CompactionInfo.withoutSSTables(this.baseCfs.metadata(), OperationType.VIEW_BUILD, this.keysBuilt, keysTotal, CompactionInfo.Unit.KEYS, this.compactionId);
    }

    @Override
    public void stop() {
        this.stop(true);
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    synchronized void stop(boolean isCompactionInterrupted) {
        this.isStopped = true;
        this.isCompactionInterrupted = isCompactionInterrupted;
    }

    long keysBuilt() {
        return this.keysBuilt;
    }

    static class StoppedException
    extends CompactionInterruptedException {
        private final String ksName;
        private final String viewName;

        private StoppedException(String ksName, String viewName, CompactionInfo info) {
            super(info);
            this.ksName = ksName;
            this.viewName = viewName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StoppedException)) {
                return false;
            }
            StoppedException that = (StoppedException)o;
            return Objects.equal((Object)this.ksName, (Object)that.ksName) && Objects.equal((Object)this.viewName, (Object)that.viewName);
        }

        public int hashCode() {
            return 31 * this.ksName.hashCode() + this.viewName.hashCode();
        }
    }
}

