/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.selection.MultiElementFactory;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SelectorFactories;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.VectorType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.transport.ProtocolVersion;

public class VectorSelector
extends Selector {
    protected static final Selector.SelectorDeserializer deserializer = new Selector.SelectorDeserializer(){

        @Override
        protected Selector deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            VectorType type = (VectorType)this.readType(metadata, in);
            ArrayList<Selector> elements = new ArrayList<Selector>(type.dimension);
            for (int i = 0; i < type.dimension; ++i) {
                elements.add(Selector.serializer.deserialize(in, version, metadata));
            }
            return new VectorSelector(type, elements);
        }
    };
    private final VectorType<?> type;
    private final List<Selector> elements;

    private VectorSelector(VectorType<?> type, List<Selector> elements) {
        super(Selector.Kind.VECTOR_SELECTOR);
        Preconditions.checkArgument((elements.size() == type.dimension ? 1 : 0) != 0, (String)"Unable to create a vector select of type %s from %s elements", (Object)type.asCQL3Type(), (int)elements.size());
        this.type = type;
        this.elements = elements;
    }

    public static Selector.Factory newFactory(AbstractType<?> type, final SelectorFactories factories) {
        assert (type.isVector()) : String.format("Unable to create vector selector from typs %s", type.asCQL3Type());
        final VectorType vt = (VectorType)type;
        return new MultiElementFactory(type, factories){

            @Override
            protected String getColumnName() {
                return Lists.listToString(factories, Selector.Factory::getColumnName);
            }

            @Override
            public Selector newInstance(QueryOptions options) {
                return new VectorSelector(vt, factories.newInstances(options));
            }
        };
    }

    @Override
    public void addFetchedColumns(ColumnFilter.Builder builder) {
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            this.elements.get(i).addFetchedColumns(builder);
        }
    }

    @Override
    public void addInput(Selector.InputRow input) {
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            this.elements.get(i).addInput(input);
        }
    }

    @Override
    public AbstractType<?> getType() {
        return this.type;
    }

    @Override
    public void reset() {
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            this.elements.get(i).reset();
        }
    }

    @Override
    public ByteBuffer getOutput(ProtocolVersion protocolVersion) throws InvalidRequestException {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.elements.size());
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            buffers.add(this.elements.get(i).getOutput(protocolVersion));
        }
        return this.type.decomposeRaw(buffers);
    }

    @Override
    protected int serializedSize(int version) {
        int size = VectorSelector.sizeOf(this.type);
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            size += serializer.serializedSize(this.elements.get(i), version);
        }
        return size;
    }

    @Override
    protected void serialize(DataOutputPlus out, int version) throws IOException {
        VectorSelector.writeType(out, this.type);
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            serializer.serialize(this.elements.get(i), out, version);
        }
    }

    @Override
    public boolean isTerminal() {
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            if (this.elements.get(i).isTerminal()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Lists.listToString(this.elements);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VectorSelector that = (VectorSelector)o;
        return this.type.equals(that.type) && this.elements.equals(that.elements);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.elements);
    }
}

