/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.util.List;
import org.apache.cassandra.cql3.selection.ColumnTimestamps;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.schema.ColumnMetadata;

interface RowTimestamps {
    public static final RowTimestamps NOOP_ROW_TIMESTAMPS = new RowTimestamps(){

        @Override
        public void addNoTimestamp(int index) {
        }

        @Override
        public void addTimestamp(int index, Cell<?> cell, long nowInSec) {
        }

        @Override
        public ColumnTimestamps get(int index) {
            return ColumnTimestamps.NO_TIMESTAMP;
        }
    };

    public void addNoTimestamp(int var1);

    public void addTimestamp(int var1, Cell<?> var2, long var3);

    public ColumnTimestamps get(int var1);

    public static RowTimestamps newInstance(ColumnTimestamps.TimestampsType type, List<ColumnMetadata> columns) {
        final ColumnTimestamps[] array = new ColumnTimestamps[columns.size()];
        int m = columns.size();
        for (int i = 0; i < m; ++i) {
            array[i] = ColumnTimestamps.newTimestamps(type, columns.get((int)i).type);
        }
        return new RowTimestamps(){

            @Override
            public void addNoTimestamp(int index) {
                array[index].addNoTimestamp();
            }

            @Override
            public void addTimestamp(int index, Cell<?> cell, long nowInSec) {
                array[index].addTimestampFrom(cell, nowInSec);
            }

            @Override
            public ColumnTimestamps get(int index) {
                return array[index];
            }
        };
    }
}

