/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregator;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregatorFactory;

class FrequencyHMAggregatorFactory
implements ThreadDumpAggregator,
ThreadDumpAggregatorFactory {
    long count = 0L;
    double reciproicalTotal = 0.0;
    long lastTimestamp = Long.MAX_VALUE;

    FrequencyHMAggregatorFactory() {
    }

    @Override
    public ThreadDumpAggregator newInstance() {
        return new FrequencyHMAggregatorFactory();
    }

    @Override
    public void aggregate(ThreadSnapshot threadInfo) {
        if (threadInfo.timestamp() > this.lastTimestamp) {
            long delta = threadInfo.timestamp() - this.lastTimestamp;
            double rcp = 1000.0 / (double)delta;
            ++this.count;
            this.reciproicalTotal += rcp;
        }
        this.lastTimestamp = threadInfo.timestamp();
    }

    @Override
    public Object info() {
        if (this.count > 0L) {
            return this.reciproicalTotal / (double)this.count;
        }
        return Double.NaN;
    }
}

