/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big;

import ch.obermuhlner.math.big.BigDecimalMath;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;

public class BigFloat
implements Comparable<BigFloat>,
Serializable {
    private static final long serialVersionUID = -7323679117445486894L;
    public static final BigFloat NaN = new SpecialBigFloat(SpecialBigFloat.Type.NaN);
    public static final BigFloat POSITIVE_INFINITY = new SpecialBigFloat(SpecialBigFloat.Type.POSITIVE_INFINITY);
    public static final BigFloat NEGATIVE_INFINITY = new SpecialBigFloat(SpecialBigFloat.Type.NEGATIVE_INFINITY);
    private final BigDecimal value;
    private final Context context;

    private BigFloat(BigDecimal value, Context context) {
        this.value = value;
        this.context = context;
    }

    public static Context context(int precision) {
        return new Context(new MathContext(precision));
    }

    public static Context context(MathContext mathContext) {
        return new Context(mathContext);
    }

    public BigFloat add(BigFloat x) {
        if (x.isSpecial()) {
            return x.add(this);
        }
        Context c = BigFloat.max(this.context, x.context);
        return c.valueOf(this.value.add(x.value, c.mathContext));
    }

    public BigFloat add(BigDecimal x) {
        return this.add(this.context.valueOf(x));
    }

    public BigFloat add(int x) {
        return this.add(this.context.valueOf(x));
    }

    public BigFloat add(long x) {
        return this.add(this.context.valueOf(x));
    }

    public BigFloat add(double x) {
        return this.add(this.context.valueOf(x));
    }

    public BigFloat subtract(BigFloat x) {
        if (x.isSpecial()) {
            return BigFloat.negate(x).add(this);
        }
        Context c = BigFloat.max(this.context, x.context);
        return c.valueOf(this.value.subtract(x.value, c.mathContext));
    }

    public BigFloat subtract(BigDecimal x) {
        return this.subtract(this.context.valueOf(x));
    }

    public BigFloat subtract(int x) {
        return this.subtract(this.context.valueOf(x));
    }

    public BigFloat subtract(long x) {
        return this.subtract(this.context.valueOf(x));
    }

    public BigFloat subtract(double x) {
        return this.subtract(this.context.valueOf(x));
    }

    public BigFloat multiply(BigFloat x) {
        if (x.isSpecial()) {
            return x.multiply(this);
        }
        Context c = BigFloat.max(this.context, x.context);
        return c.valueOf(this.value.multiply(x.value, c.mathContext));
    }

    public BigFloat multiply(BigDecimal x) {
        return this.multiply(this.context.valueOf(x));
    }

    public BigFloat multiply(int x) {
        return this.multiply(this.context.valueOf(x));
    }

    public BigFloat multiply(long x) {
        return this.multiply(this.context.valueOf(x));
    }

    public BigFloat multiply(double x) {
        return this.multiply(this.context.valueOf(x));
    }

    public BigFloat divide(BigFloat x) {
        if (x.isSpecial()) {
            if (x == NaN) {
                return NaN;
            }
            return this.context.valueOf(0);
        }
        if (this.isZero() && !x.isZero()) {
            return this.context.valueOf(0);
        }
        if (x.isZero()) {
            if (this.isZero()) {
                return NaN;
            }
            if (this.isNegative()) {
                return NEGATIVE_INFINITY;
            }
            return POSITIVE_INFINITY;
        }
        Context c = BigFloat.max(this.context, x.context);
        return c.valueOf(this.value.divide(x.value, c.mathContext));
    }

    public BigFloat divide(BigDecimal x) {
        return this.divide(this.context.valueOf(x));
    }

    public BigFloat divide(int x) {
        return this.divide(this.context.valueOf(x));
    }

    public BigFloat divide(long x) {
        return this.divide(this.context.valueOf(x));
    }

    public BigFloat divide(double x) {
        return this.divide(this.context.valueOf(x));
    }

    public BigFloat remainder(BigFloat x) {
        if (x.isSpecial()) {
            if (x == NaN) {
                return NaN;
            }
            return this;
        }
        if (this.isZero() && !x.isZero()) {
            return this.context.valueOf(0);
        }
        if (x.isZero()) {
            return NaN;
        }
        Context c = BigFloat.max(this.context, x.context);
        return c.valueOf(this.value.remainder(x.value, c.mathContext));
    }

    public BigFloat remainder(BigDecimal x) {
        return this.remainder(this.context.valueOf(x));
    }

    public BigFloat remainder(int x) {
        return this.remainder(this.context.valueOf(x));
    }

    public BigFloat remainder(long x) {
        return this.remainder(this.context.valueOf(x));
    }

    public BigFloat remainder(double x) {
        return this.remainder(this.context.valueOf(x));
    }

    public BigFloat pow(BigFloat y) {
        if (y.isSpecial()) {
            if (this.isZero()) {
                if (y == POSITIVE_INFINITY) {
                    return this;
                }
                if (y == NEGATIVE_INFINITY) {
                    return POSITIVE_INFINITY;
                }
            }
            if (y == NEGATIVE_INFINITY) {
                return this.context.ZERO;
            }
            return y;
        }
        if (this.isZero() && y.isNegative()) {
            return POSITIVE_INFINITY;
        }
        Context c = BigFloat.max(this.context, y.context);
        return c.valueOf(BigDecimalMath.pow(this.value, y.value, c.mathContext));
    }

    public BigFloat pow(BigDecimal y) {
        return this.pow(this.context.valueOf(y));
    }

    public BigFloat pow(int y) {
        return this.pow(this.context.valueOf(y));
    }

    public BigFloat pow(long y) {
        return this.pow(this.context.valueOf(y));
    }

    public BigFloat pow(double y) {
        return this.pow(this.context.valueOf(y));
    }

    public BigFloat root(BigFloat y) {
        if (y.isSpecial()) {
            return y;
        }
        Context c = BigFloat.max(this.context, y.context);
        return c.valueOf(BigDecimalMath.root(this.value, y.value, c.mathContext));
    }

    public BigFloat root(BigDecimal y) {
        return this.root(this.context.valueOf(y));
    }

    public BigFloat root(int y) {
        return this.root(this.context.valueOf(y));
    }

    public BigFloat root(long y) {
        return this.root(this.context.valueOf(y));
    }

    public BigFloat root(double y) {
        return this.root(this.context.valueOf(y));
    }

    public int hashCode() {
        return this.value.stripTrailingZeros().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigFloat other = (BigFloat)obj;
        return this.value.compareTo(other.value) == 0;
    }

    public int signum() {
        return this.value.signum();
    }

    public boolean isNegative() {
        return this.value.signum() < 0;
    }

    public boolean isZero() {
        return this.value.signum() == 0;
    }

    public boolean isPositive() {
        return this.value.signum() > 0;
    }

    @Override
    public int compareTo(BigFloat other) {
        if (other.isSpecial()) {
            return -other.compareTo(this);
        }
        return this.value.compareTo(other.value);
    }

    public boolean isEqual(BigFloat other) {
        if (this == NaN || other == NaN) {
            return false;
        }
        return this.compareTo(other) == 0;
    }

    public boolean isLessThan(BigFloat other) {
        if (this == NaN || other == NaN) {
            return false;
        }
        return this.compareTo(other) < 0;
    }

    public boolean isGreaterThan(BigFloat other) {
        if (this == NaN || other == NaN) {
            return false;
        }
        return this.compareTo(other) > 0;
    }

    public boolean isLessThanOrEqual(BigFloat other) {
        if (this == NaN || other == NaN) {
            return false;
        }
        return this.compareTo(other) <= 0;
    }

    public boolean isGreaterThanOrEqual(BigFloat other) {
        if (this == NaN || other == NaN) {
            return false;
        }
        return this.compareTo(other) >= 0;
    }

    public boolean isIntValue() {
        return BigDecimalMath.isIntValue(this.value);
    }

    public boolean isDoubleValue() {
        return BigDecimalMath.isDoubleValue(this.value);
    }

    public BigFloat getMantissa() {
        return this.context.valueOf(BigDecimalMath.mantissa(this.value));
    }

    public BigFloat getExponent() {
        return this.context.valueOf(BigDecimalMath.exponent(this.value));
    }

    public BigFloat getIntegralPart() {
        return this.context.valueOf(BigDecimalMath.integralPart(this.value));
    }

    public BigFloat getFractionalPart() {
        return this.context.valueOf(BigDecimalMath.fractionalPart(this.value));
    }

    public Context getContext() {
        return this.context;
    }

    public BigDecimal toBigDecimal() {
        return this.value;
    }

    public double toDouble() {
        return this.value.doubleValue();
    }

    public long toLong() {
        return this.value.longValue();
    }

    public int toInt() {
        return this.value.intValue();
    }

    public String toString() {
        return this.value.toString();
    }

    protected boolean isSpecial() {
        return false;
    }

    protected SpecialBigFloat.Type type() {
        return SpecialBigFloat.Type.NORMAL;
    }

    public boolean isNaN() {
        return this == NaN;
    }

    public boolean isInfinity() {
        return this == POSITIVE_INFINITY || this == NEGATIVE_INFINITY;
    }

    public static BigFloat negate(BigFloat x) {
        if (x.isSpecial()) {
            if (x.isInfinity()) {
                return x == POSITIVE_INFINITY ? NEGATIVE_INFINITY : POSITIVE_INFINITY;
            }
            return NaN;
        }
        return x.context.valueOf(x.value.negate());
    }

    public static BigFloat abs(BigFloat x) {
        if (x.isSpecial()) {
            return x.isInfinity() ? POSITIVE_INFINITY : NaN;
        }
        return x.context.valueOf(x.value.abs());
    }

    public static BigFloat max(BigFloat value1, BigFloat value2) {
        return value1.compareTo(value2) >= 0 ? value1 : value2;
    }

    public static BigFloat max(BigFloat value1, BigFloat ... values) {
        BigFloat result = value1;
        for (BigFloat other : values) {
            result = BigFloat.max(result, other);
        }
        return result;
    }

    public static BigFloat min(BigFloat value1, BigFloat value2) {
        return value1.compareTo(value2) < 0 ? value1 : value2;
    }

    public static BigFloat min(BigFloat value1, BigFloat ... values) {
        BigFloat result = value1;
        for (BigFloat other : values) {
            result = BigFloat.min(result, other);
        }
        return result;
    }

    private static BigFloat logSpecial(BigFloat val) {
        if (val.isNaN() || val.isNegative()) {
            return NaN;
        }
        if (val == POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (val.isZero()) {
            return NEGATIVE_INFINITY;
        }
        return null;
    }

    public static BigFloat log(BigFloat x) {
        BigFloat temp = BigFloat.logSpecial(x);
        return temp != null ? temp : x.context.valueOf(BigDecimalMath.log(x.value, x.context.mathContext));
    }

    public static BigFloat log2(BigFloat x) {
        BigFloat temp = BigFloat.logSpecial(x);
        return temp != null ? temp : x.context.valueOf(BigDecimalMath.log2(x.value, x.context.mathContext));
    }

    public static BigFloat log10(BigFloat x) {
        BigFloat temp = BigFloat.logSpecial(x);
        return temp != null ? temp : x.context.valueOf(BigDecimalMath.log10(x.value, x.context.mathContext));
    }

    public static BigFloat exp(BigFloat x) {
        if (x.isSpecial()) {
            return x != NEGATIVE_INFINITY ? x : x.context.ZERO;
        }
        return x.context.valueOf(BigDecimalMath.exp(x.value, x.context.mathContext));
    }

    public static BigFloat sqrt(BigFloat x) {
        if (x.isNaN() || x.isNegative()) {
            return NaN;
        }
        if (x.isZero() || x.isInfinity()) {
            return x;
        }
        return x.context.valueOf(BigDecimalMath.sqrt(x.value, x.context.mathContext));
    }

    public static BigFloat pow(BigFloat x, BigFloat y) {
        Context c = BigFloat.max(x.context, y.context);
        return c.valueOf(BigDecimalMath.pow(x.value, y.value, c.mathContext));
    }

    public static BigFloat root(BigFloat x, BigFloat y) {
        Context c = BigFloat.max(x.context, y.context);
        return c.valueOf(BigDecimalMath.root(x.value, y.value, c.mathContext));
    }

    public static BigFloat sin(BigFloat x) {
        if (x.isSpecial()) {
            return NaN;
        }
        if (x.isZero()) {
            return x;
        }
        return x.context.valueOf(BigDecimalMath.sin(x.value, x.context.mathContext));
    }

    public static BigFloat cos(BigFloat x) {
        if (x.isSpecial()) {
            return NaN;
        }
        return x.context.valueOf(BigDecimalMath.cos(x.value, x.context.mathContext));
    }

    public static BigFloat tan(BigFloat x) {
        if (x.isSpecial()) {
            return NaN;
        }
        if (x.isZero()) {
            return x;
        }
        return x.context.valueOf(BigDecimalMath.tan(x.value, x.context.mathContext));
    }

    public static BigFloat cot(BigFloat x) {
        if (x.isSpecial()) {
            return x;
        }
        if (x.isZero()) {
            return POSITIVE_INFINITY;
        }
        return x.context.valueOf(BigDecimalMath.cot(x.value, x.context.mathContext));
    }

    public static BigFloat asin(BigFloat x) {
        if (x.isZero()) {
            return x;
        }
        return x.isNaN() || !BigFloat.isRangeAbs1(x) ? NaN : x.context.valueOf(BigDecimalMath.asin(x.value, x.context.mathContext));
    }

    public static BigFloat acos(BigFloat x) {
        return x.isNaN() || !BigFloat.isRangeAbs1(x) ? NaN : x.context.valueOf(BigDecimalMath.acos(x.value, x.context.mathContext));
    }

    private static boolean isRangeAbs1(BigFloat x) {
        return BigFloat.isBetween(x.context.NEGATIVE_ONE, x.context.ONE, x);
    }

    public static BigFloat atan(BigFloat x) {
        return x.isSpecial() || x.isZero() ? x : x.context.valueOf(BigDecimalMath.atan(x.value, x.context.mathContext));
    }

    public static BigFloat acot(BigFloat x) {
        return x.isSpecial() ? x : x.context.valueOf(BigDecimalMath.acot(x.value, x.context.mathContext));
    }

    public static BigFloat sinh(BigFloat x) {
        if (x.isSpecial() || x.isZero()) {
            return x;
        }
        return x.context.valueOf(BigDecimalMath.sinh(x.value, x.context.mathContext));
    }

    public static BigFloat cosh(BigFloat x) {
        if (x.isNaN()) {
            return NaN;
        }
        if (x.isInfinity()) {
            return POSITIVE_INFINITY;
        }
        if (x.isZero()) {
            return x.context.ONE;
        }
        return x.context.valueOf(BigDecimalMath.cosh(x.value, x.context.mathContext));
    }

    public static BigFloat tanh(BigFloat x) {
        if (x.isNaN() || x.isZero()) {
            return x;
        }
        if (x.isInfinity()) {
            return x == POSITIVE_INFINITY ? x.context.ONE : x.context.NEGATIVE_ONE;
        }
        return x.context.valueOf(BigDecimalMath.tanh(x.value, x.context.mathContext));
    }

    public static BigFloat coth(BigFloat x) {
        if (x.isSpecial()) {
            return x;
        }
        return x.context.valueOf(BigDecimalMath.coth(x.value, x.context.mathContext));
    }

    public static BigFloat asinh(BigFloat x) {
        if (x.isSpecial()) {
            return x;
        }
        return x.context.valueOf(BigDecimalMath.asinh(x.value, x.context.mathContext));
    }

    public static BigFloat acosh(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.acosh(x.value, x.context.mathContext));
    }

    public static BigFloat atanh(BigFloat x) {
        if (x.isSpecial()) {
            return x;
        }
        return x.context.valueOf(BigDecimalMath.atanh(x.value, x.context.mathContext));
    }

    public static BigFloat acoth(BigFloat x) {
        if (x.isSpecial()) {
            return x;
        }
        return x.context.valueOf(BigDecimalMath.acoth(x.value, x.context.mathContext));
    }

    public static boolean isBetween(BigFloat min, BigFloat max, BigFloat value) {
        return value.compareTo(min) >= 0 && value.compareTo(max) <= 0;
    }

    private static Context max(Context left, Context right) {
        return left.mathContext.getPrecision() > right.mathContext.getPrecision() ? left : right;
    }

    public static class Context
    implements Serializable {
        private static final long serialVersionUID = -5787473786808803161L;
        public final BigFloat NEGATIVE_ONE;
        public final BigFloat ZERO;
        public final BigFloat ONE;
        private final MathContext mathContext;

        private Context(MathContext mathContext) {
            this.mathContext = mathContext;
            this.NEGATIVE_ONE = this.valueOf(-1);
            this.ZERO = this.valueOf(0);
            this.ONE = this.valueOf(1);
        }

        public MathContext getMathContext() {
            return this.mathContext;
        }

        public int getPrecision() {
            return this.mathContext.getPrecision();
        }

        public RoundingMode getRoundingMode() {
            return this.mathContext.getRoundingMode();
        }

        public BigFloat valueOf(BigFloat value) {
            return value.isSpecial() ? value : new BigFloat(value.value.round(this.mathContext), this);
        }

        public BigFloat valueOf(BigDecimal value) {
            return new BigFloat(value.round(this.mathContext), this);
        }

        public BigFloat valueOf(int value) {
            return new BigFloat(new BigDecimal(value, this.mathContext), this);
        }

        public BigFloat valueOf(int value, boolean unsigned) {
            if (!unsigned) {
                return new BigFloat(new BigDecimal(value, this.mathContext), this);
            }
            if (value > -1) {
                return this.valueOf(value, false);
            }
            return new BigFloat(new BigDecimal(Integer.MAX_VALUE).add(new BigDecimal(value & Integer.MAX_VALUE)).add(BigDecimal.ONE), this);
        }

        public BigFloat valueOf(long value) {
            return new BigFloat(new BigDecimal(value, this.mathContext), this);
        }

        public BigFloat valueOf(long value, boolean unsigned) {
            if (!unsigned) {
                return new BigFloat(new BigDecimal(value, this.mathContext), this);
            }
            if (value > -1L) {
                return this.valueOf(value, false);
            }
            return new BigFloat(new BigDecimal(Long.MAX_VALUE).add(new BigDecimal(value & Long.MAX_VALUE)).add(BigDecimal.ONE), this);
        }

        public BigFloat valueOf(double value) {
            if (Double.isInfinite(value)) {
                return value == Double.POSITIVE_INFINITY ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
            }
            if (Double.isNaN(value)) {
                return NaN;
            }
            return new BigFloat(new BigDecimal(String.valueOf(value), this.mathContext), this);
        }

        public BigFloat valueOf(String value) {
            return new BigFloat(new BigDecimal(value, this.mathContext), this);
        }

        public BigFloat pi() {
            return this.valueOf(BigDecimalMath.pi(this.mathContext));
        }

        public BigFloat e() {
            return this.valueOf(BigDecimalMath.e(this.mathContext));
        }

        public BigFloat factorial(int n) {
            return this.valueOf(BigDecimalMath.factorial(n));
        }

        public int hashCode() {
            return this.mathContext.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Context other = (Context)obj;
            return this.mathContext.equals(other.mathContext);
        }

        public String toString() {
            return this.mathContext.toString();
        }
    }

    private static final class SpecialBigFloat
    extends BigFloat {
        private static final Context DUMMY_CONTEXT = BigFloat.context(MathContext.DECIMAL32);
        private final Type type;

        private SpecialBigFloat(Type type) {
            super(null, DUMMY_CONTEXT);
            this.type = type;
        }

        @Override
        protected boolean isSpecial() {
            return true;
        }

        @Override
        protected Type type() {
            return this.type;
        }

        @Override
        public BigFloat add(BigFloat x) {
            if (!x.isSpecial()) {
                return this;
            }
            if (this == POSITIVE_INFINITY && x == POSITIVE_INFINITY) {
                return POSITIVE_INFINITY;
            }
            if (this == NEGATIVE_INFINITY && x == NEGATIVE_INFINITY) {
                return NEGATIVE_INFINITY;
            }
            return NaN;
        }

        @Override
        public BigFloat subtract(BigFloat x) {
            if (!x.isSpecial()) {
                return this;
            }
            if (this == POSITIVE_INFINITY && x == NEGATIVE_INFINITY) {
                return POSITIVE_INFINITY;
            }
            if (this == NEGATIVE_INFINITY && x == POSITIVE_INFINITY) {
                return NEGATIVE_INFINITY;
            }
            return NaN;
        }

        @Override
        public BigFloat subtract(BigDecimal x) {
            return this;
        }

        @Override
        public BigFloat multiply(BigFloat x) {
            if (x.isZero() || x == NaN) {
                return NaN;
            }
            if (x.isNegative()) {
                return SpecialBigFloat.negate(this);
            }
            return this;
        }

        @Override
        public BigFloat divide(BigFloat x) {
            if (x == NaN || this.isInfinity() && x.isInfinity()) {
                return NaN;
            }
            if (x.isNegative()) {
                return SpecialBigFloat.negate(this);
            }
            return this;
        }

        @Override
        public BigFloat remainder(BigFloat x) {
            return NaN;
        }

        @Override
        public BigFloat pow(BigFloat y) {
            if (y.isZero()) {
                return ((BigFloat)y).context.ONE;
            }
            if (y == NaN) {
                return NaN;
            }
            if (this.isInfinity() && y.isNegative()) {
                return ((BigFloat)y).context.ZERO;
            }
            if (this == NEGATIVE_INFINITY && y.isPositive()) {
                return POSITIVE_INFINITY;
            }
            return this;
        }

        @Override
        public BigFloat root(BigFloat y) {
            return this;
        }

        @Override
        public int hashCode() {
            return this.type.hashCode;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof BigFloat && ((BigFloat)obj).isSpecial() && ((BigFloat)obj).type() == this.type;
        }

        @Override
        public int signum() {
            return this.type == Type.POSITIVE_INFINITY ? 1 : -1;
        }

        @Override
        public boolean isNegative() {
            return this.signum() < 0;
        }

        @Override
        public boolean isZero() {
            return false;
        }

        @Override
        public boolean isPositive() {
            return this.signum() > 0;
        }

        @Override
        public int compareTo(BigFloat other) {
            return Type.compare(this.type, other.type());
        }

        @Override
        public boolean isIntValue() {
            return false;
        }

        @Override
        public boolean isDoubleValue() {
            return false;
        }

        @Override
        public BigFloat getMantissa() {
            return this;
        }

        @Override
        public BigFloat getExponent() {
            return this;
        }

        @Override
        public BigFloat getIntegralPart() {
            return this;
        }

        @Override
        public BigFloat getFractionalPart() {
            return this;
        }

        @Override
        public Context getContext() {
            throw new UnsupportedOperationException((Object)((Object)this.type) + " has no context");
        }

        @Override
        public BigDecimal toBigDecimal() {
            throw new UnsupportedOperationException((Object)((Object)this.type) + " has no corresponding BigDecimal representation");
        }

        @Override
        public double toDouble() {
            return this.type.toDouble();
        }

        @Override
        public long toLong() {
            return (long)this.toDouble();
        }

        @Override
        public int toInt() {
            return (int)this.toDouble();
        }

        @Override
        public String toString() {
            return this.type.toString();
        }

        static enum Type {
            NaN(Objects.hashCode(Double.NaN)),
            POSITIVE_INFINITY(Objects.hashCode(Double.POSITIVE_INFINITY)),
            NORMAL(Objects.hashCode(0)),
            NEGATIVE_INFINITY(Objects.hashCode(Double.NEGATIVE_INFINITY));

            final int hashCode;

            private Type(int hashCode) {
                this.hashCode = hashCode;
            }

            public static int compare(Type a, Type b) {
                return Double.compare(a.toDouble(), b.toDouble());
            }

            public double toDouble() {
                switch (this) {
                    case POSITIVE_INFINITY: {
                        return Double.POSITIVE_INFINITY;
                    }
                    case NEGATIVE_INFINITY: {
                        return Double.NEGATIVE_INFINITY;
                    }
                    case NaN: {
                        return Double.NaN;
                    }
                }
                return 0.0;
            }
        }
    }
}

