/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.commons.lang3.ArrayUtils;

public enum ProtocolVersion implements Comparable<ProtocolVersion>
{
    V1(1, "v1", false),
    V2(2, "v2", false),
    V3(3, "v3", false),
    V4(4, "v4", false),
    V5(5, "v5", false),
    V6(6, "v6-beta", true);

    private final int num;
    private final String descr;
    private final boolean beta;
    private static final ProtocolVersion[] SUPPORTED_VERSIONS;
    static final ProtocolVersion MIN_SUPPORTED_VERSION;
    static final ProtocolVersion MAX_SUPPORTED_VERSION;
    private static int[] KNOWN_INVALID_VERSIONS;
    public static final EnumSet<ProtocolVersion> SUPPORTED;
    public static final EnumSet<ProtocolVersion> UNSUPPORTED;
    public static final ProtocolVersion CURRENT;
    public static final Optional<ProtocolVersion> BETA;

    private ProtocolVersion(int num, String descr, boolean beta) {
        this.num = num;
        this.descr = descr;
        this.beta = beta;
    }

    public static List<String> supportedVersions() {
        ArrayList<String> ret = new ArrayList<String>(SUPPORTED.size());
        for (ProtocolVersion version : SUPPORTED) {
            ret.add(version.toString());
        }
        return ret;
    }

    public static List<ProtocolVersion> supportedVersionsStartingWith(ProtocolVersion smallestVersion) {
        ArrayList<ProtocolVersion> versions = new ArrayList<ProtocolVersion>(SUPPORTED_VERSIONS.length);
        for (ProtocolVersion version : SUPPORTED_VERSIONS) {
            if (!version.isGreaterOrEqualTo(smallestVersion)) continue;
            versions.add(version);
        }
        return versions;
    }

    public static ProtocolVersion decode(int versionNum, boolean allowOlderProtocols) {
        ProtocolVersion ret;
        ProtocolVersion protocolVersion = ret = versionNum >= ProtocolVersion.MIN_SUPPORTED_VERSION.num && versionNum <= ProtocolVersion.MAX_SUPPORTED_VERSION.num ? SUPPORTED_VERSIONS[versionNum - ProtocolVersion.MIN_SUPPORTED_VERSION.num] : null;
        if (ret == null) {
            for (ProtocolVersion version : UNSUPPORTED) {
                if (version.num != versionNum) continue;
                throw new ProtocolException(ProtocolVersion.invalidVersionMessage(versionNum), version);
            }
            for (Object dseVersion : (Object)KNOWN_INVALID_VERSIONS) {
                if (versionNum != dseVersion) continue;
                throw ProtocolException.toSilentException(new ProtocolException(ProtocolVersion.invalidVersionMessage(versionNum)));
            }
            throw new ProtocolException(ProtocolVersion.invalidVersionMessage(versionNum));
        }
        if (!allowOlderProtocols && ret.isSmallerThan(CURRENT)) {
            throw new ProtocolException(String.format("Rejecting Protocol Version %s < %s.", ret, CURRENT));
        }
        return ret;
    }

    public boolean isBeta() {
        return this.beta;
    }

    public static String invalidVersionMessage(int version) {
        return String.format("Invalid or unsupported protocol version (%d); supported versions are (%s)", version, String.join((CharSequence)", ", ProtocolVersion.supportedVersions()));
    }

    public int asInt() {
        return this.num;
    }

    public String toString() {
        return String.format("%d/%s", this.num, this.descr);
    }

    public final boolean isGreaterThan(ProtocolVersion other) {
        return this.num > other.num;
    }

    public final boolean isGreaterOrEqualTo(ProtocolVersion other) {
        return this.num >= other.num;
    }

    public final boolean isSmallerThan(ProtocolVersion other) {
        return this.num < other.num;
    }

    public final boolean isSmallerOrEqualTo(ProtocolVersion other) {
        return this.num <= other.num;
    }

    static {
        SUPPORTED_VERSIONS = new ProtocolVersion[]{V3, V4, V5, V6};
        MIN_SUPPORTED_VERSION = SUPPORTED_VERSIONS[0];
        MAX_SUPPORTED_VERSION = SUPPORTED_VERSIONS[SUPPORTED_VERSIONS.length - 1];
        KNOWN_INVALID_VERSIONS = new int[]{66, 65};
        SUPPORTED = EnumSet.copyOf(Arrays.asList(ArrayUtils.addAll((Object[])SUPPORTED_VERSIONS, (Object[])new ProtocolVersion[0])));
        UNSUPPORTED = EnumSet.complementOf(SUPPORTED);
        CURRENT = V5;
        BETA = Optional.of(V6);
    }
}

