/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.DurationType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.NumberType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.StringType;
import org.apache.cassandra.db.marshal.TemporalType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.OperationExecutionException;
import org.apache.cassandra.transport.ProtocolVersion;

public final class OperationFcts {
    public static final String NEGATION_FUNCTION_NAME = "_negate";

    public static Collection<Function> all() {
        NumberType[] numericTypes;
        ArrayList<Function> functions = new ArrayList<Function>();
        for (NumberType numberType : numericTypes = new NumberType[]{ByteType.instance, ShortType.instance, Int32Type.instance, LongType.instance, FloatType.instance, DoubleType.instance, DecimalType.instance, IntegerType.instance, CounterColumnType.instance}) {
            for (NumberType right : numericTypes) {
                NumberType<?> returnType = OperationFcts.returnType(numberType, right);
                for (OPERATION operation : OPERATION.values()) {
                    functions.add(new NumericOperationFunction(returnType, numberType, operation, right));
                }
            }
            functions.add(new NumericNegationFunction(numberType));
        }
        for (OPERATION oPERATION : new OPERATION[]{OPERATION.ADDITION, OPERATION.SUBSTRACTION}) {
            functions.add(new TemporalOperationFunction(TimestampType.instance, oPERATION));
            functions.add(new TemporalOperationFunction(SimpleDateType.instance, oPERATION));
        }
        OperationFcts.addStringConcatenations(functions);
        return functions;
    }

    private static void addStringConcatenations(List<Function> functions) {
        functions.add(new StringOperationFunction(UTF8Type.instance, UTF8Type.instance, OPERATION.ADDITION, UTF8Type.instance));
        functions.add(new StringOperationFunction(AsciiType.instance, AsciiType.instance, OPERATION.ADDITION, AsciiType.instance));
        functions.add(new StringOperationFunction(UTF8Type.instance, AsciiType.instance, OPERATION.ADDITION, UTF8Type.instance));
        functions.add(new StringOperationFunction(UTF8Type.instance, UTF8Type.instance, OPERATION.ADDITION, AsciiType.instance));
    }

    public static boolean isOperation(FunctionName function) {
        return "system".equals(function.keyspace) && OPERATION.fromFunctionName(function.name) != null;
    }

    public static boolean isNegation(FunctionName function) {
        return "system".equals(function.keyspace) && NEGATION_FUNCTION_NAME.equals(function.name);
    }

    public static char getOperator(FunctionName function) {
        assert ("system".equals(function.keyspace));
        return OPERATION.fromFunctionName(function.name).symbol;
    }

    public static FunctionName getFunctionNameFromOperator(char operator) {
        return FunctionName.nativeFunction(OPERATION.fromSymbol(operator).functionName);
    }

    private static NumberType<?> returnType(NumberType<?> left, NumberType<?> right) {
        boolean isFloatingPoint = left.isFloatingPoint() || right.isFloatingPoint();
        int size = Math.max(OperationFcts.size(left), OperationFcts.size(right));
        return isFloatingPoint ? OperationFcts.floatPointType(size) : OperationFcts.integerType(size);
    }

    private static int size(NumberType<?> type) {
        int size = type.valueLengthIfFixed();
        if (size > 0) {
            return size;
        }
        if (type == ByteType.instance) {
            return 1;
        }
        if (type == ShortType.instance) {
            return 2;
        }
        if (type.isCounter()) {
            return LongType.instance.valueLengthIfFixed();
        }
        return Integer.MAX_VALUE;
    }

    private static NumberType<?> floatPointType(int size) {
        switch (size) {
            case 4: {
                return FloatType.instance;
            }
            case 8: {
                return DoubleType.instance;
            }
        }
        return DecimalType.instance;
    }

    private static NumberType<?> integerType(int size) {
        switch (size) {
            case 1: {
                return ByteType.instance;
            }
            case 2: {
                return ShortType.instance;
            }
            case 4: {
                return Int32Type.instance;
            }
            case 8: {
                return LongType.instance;
            }
        }
        return IntegerType.instance;
    }

    private OperationFcts() {
    }

    private static class NumericNegationFunction
    extends NativeScalarFunction {
        public NumericNegationFunction(NumberType<?> inputType) {
            super(OperationFcts.NEGATION_FUNCTION_NAME, inputType, inputType);
        }

        @Override
        public final String columnName(List<String> columnNames) {
            return String.format("-%s", columnNames.get(0));
        }

        @Override
        public final ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer input = parameters.get(0);
            if (input == null) {
                return null;
            }
            NumberType inputType = (NumberType)this.argTypes().get(0);
            return inputType.negate(input);
        }
    }

    private static class TemporalOperationFunction
    extends OperationFunction {
        public TemporalOperationFunction(TemporalType<?> type, OPERATION operation) {
            super(type, type, operation, DurationType.instance);
        }

        @Override
        protected ByteBuffer doExecute(ByteBuffer left, OPERATION operation, ByteBuffer right) {
            TemporalType resultType = (TemporalType)this.returnType();
            return operation.executeOnTemporals(resultType, left, right);
        }
    }

    private static class StringOperationFunction
    extends OperationFunction {
        public StringOperationFunction(StringType returnType, StringType left, OPERATION operation, StringType right) {
            super(returnType, left, operation, right);
        }

        @Override
        protected ByteBuffer doExecute(ByteBuffer left, OPERATION operation, ByteBuffer right) {
            StringType leftType = (StringType)this.argTypes().get(0);
            StringType rightType = (StringType)this.argTypes().get(1);
            StringType resultType = (StringType)this.returnType();
            return operation.excuteOnStrings(resultType, leftType, left, rightType, right);
        }
    }

    private static class NumericOperationFunction
    extends OperationFunction {
        public NumericOperationFunction(NumberType<?> returnType, NumberType<?> left, OPERATION operation, NumberType<?> right) {
            super(returnType, left, operation, right);
        }

        @Override
        protected ByteBuffer doExecute(ByteBuffer left, OPERATION operation, ByteBuffer right) {
            NumberType leftType = (NumberType)this.argTypes().get(0);
            NumberType rightType = (NumberType)this.argTypes().get(1);
            NumberType resultType = (NumberType)this.returnType();
            return operation.executeOnNumerics(resultType, leftType, left, rightType, right);
        }
    }

    private static abstract class OperationFunction
    extends NativeScalarFunction {
        private final OPERATION operation;

        public OperationFunction(AbstractType<?> returnType, AbstractType<?> left, OPERATION operation, AbstractType<?> right) {
            super(operation.functionName, returnType, left, right);
            this.operation = operation;
        }

        @Override
        public final String columnName(List<String> columnNames) {
            return String.format("%s %s %s", columnNames.get(0), Character.valueOf(this.getOperator()), columnNames.get(1));
        }

        @Override
        public final ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer left = parameters.get(0);
            ByteBuffer right = parameters.get(1);
            if (left == null || !left.hasRemaining() || right == null || !right.hasRemaining()) {
                return null;
            }
            try {
                return this.doExecute(left, this.operation, right);
            }
            catch (Exception e) {
                throw OperationExecutionException.create(this.getOperator(), this.argTypes, e);
            }
        }

        protected abstract ByteBuffer doExecute(ByteBuffer var1, OPERATION var2, ByteBuffer var3);

        private final char getOperator() {
            return this.operation.symbol;
        }
    }

    private static enum OPERATION {
        ADDITION('+', "_add"){

            @Override
            protected ByteBuffer executeOnNumerics(NumberType<?> resultType, NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
                return resultType.add(leftType, left, rightType, right);
            }

            @Override
            protected ByteBuffer executeOnTemporals(TemporalType<?> type, ByteBuffer temporal, ByteBuffer duration) {
                return type.addDuration(temporal, duration);
            }

            @Override
            protected ByteBuffer excuteOnStrings(StringType resultType, StringType leftType, ByteBuffer left, StringType rightType, ByteBuffer right) {
                return resultType.concat(leftType, left, rightType, right);
            }
        }
        ,
        SUBSTRACTION('-', "_substract"){

            @Override
            protected ByteBuffer executeOnNumerics(NumberType<?> resultType, NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
                return resultType.substract(leftType, left, rightType, right);
            }

            @Override
            protected ByteBuffer executeOnTemporals(TemporalType<?> type, ByteBuffer temporal, ByteBuffer duration) {
                return type.substractDuration(temporal, duration);
            }
        }
        ,
        MULTIPLICATION('*', "_multiply"){

            @Override
            protected ByteBuffer executeOnNumerics(NumberType<?> resultType, NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
                return resultType.multiply(leftType, left, rightType, right);
            }
        }
        ,
        DIVISION('/', "_divide"){

            @Override
            protected ByteBuffer executeOnNumerics(NumberType<?> resultType, NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
                return resultType.divide(leftType, left, rightType, right);
            }
        }
        ,
        MODULO('%', "_modulo"){

            @Override
            protected ByteBuffer executeOnNumerics(NumberType<?> resultType, NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
                return resultType.mod(leftType, left, rightType, right);
            }
        };

        private final char symbol;
        private final String functionName;

        private OPERATION(char symbol, String functionName) {
            this.symbol = symbol;
            this.functionName = functionName;
        }

        protected abstract ByteBuffer executeOnNumerics(NumberType<?> var1, NumberType<?> var2, ByteBuffer var3, NumberType<?> var4, ByteBuffer var5);

        protected ByteBuffer executeOnTemporals(TemporalType<?> type, ByteBuffer temporal, ByteBuffer duration) {
            throw new UnsupportedOperationException();
        }

        protected ByteBuffer excuteOnStrings(StringType resultType, StringType leftType, ByteBuffer left, StringType rightType, ByteBuffer right) {
            throw new UnsupportedOperationException();
        }

        public static OPERATION fromFunctionName(String functionName) {
            for (OPERATION operator : OPERATION.values()) {
                if (!operator.functionName.equals(functionName)) continue;
                return operator;
            }
            return null;
        }

        public static OPERATION fromSymbol(char symbol) {
            for (OPERATION operator : OPERATION.values()) {
                if (operator.symbol != symbol) continue;
                return operator;
            }
            return null;
        }
    }
}

