/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import com.google.common.util.concurrent.Uninterruptibles;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.stress.operations.OpDistributionFactory;
import org.apache.cassandra.stress.settings.Command;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionDistribution;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.stress.settings.SettingsCommandPreDefined;
import org.apache.cassandra.stress.settings.SettingsCommandPreDefinedMixed;
import org.apache.cassandra.stress.settings.SettingsCommandUser;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JavaDriverClient;
import org.apache.cassandra.stress.util.ResultLogger;

public abstract class SettingsCommand
implements Serializable {
    public final Command type;
    public final long count;
    public final long duration;
    public final TimeUnit durationUnits;
    public final boolean noWarmup;
    public final TruncateWhen truncate;
    public final ConsistencyLevel consistencyLevel;
    public final double targetUncertainty;
    public final int minimumUncertaintyMeasurements;
    public final int maximumUncertaintyMeasurements;

    public abstract OpDistributionFactory getFactory(StressSettings var1);

    public SettingsCommand(Command type, GroupedOptions options) {
        this(type, (Options)options, options instanceof Count ? (Count)options : null, options instanceof Duration ? (Duration)options : null, options instanceof Uncertainty ? (Uncertainty)options : null);
    }

    public SettingsCommand(Command type, Options options, Count count, Duration duration, Uncertainty uncertainty) {
        this.type = type;
        this.consistencyLevel = ConsistencyLevel.valueOf((String)options.consistencyLevel.value().toUpperCase());
        this.noWarmup = options.noWarmup.setByUser();
        this.truncate = TruncateWhen.valueOf(options.truncate.value().toUpperCase());
        if (count != null) {
            this.count = OptionDistribution.parseLong(count.count.value());
            this.duration = 0L;
            this.durationUnits = null;
            this.targetUncertainty = -1.0;
            this.minimumUncertaintyMeasurements = -1;
            this.maximumUncertaintyMeasurements = -1;
        } else if (duration != null) {
            this.count = -1L;
            this.duration = Long.parseLong(duration.duration.value().substring(0, duration.duration.value().length() - 1));
            switch (duration.duration.value().toLowerCase().charAt(duration.duration.value().length() - 1)) {
                case 's': {
                    this.durationUnits = TimeUnit.SECONDS;
                    break;
                }
                case 'm': {
                    this.durationUnits = TimeUnit.MINUTES;
                    break;
                }
                case 'h': {
                    this.durationUnits = TimeUnit.HOURS;
                    break;
                }
                case 'd': {
                    this.durationUnits = TimeUnit.DAYS;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.targetUncertainty = -1.0;
            this.minimumUncertaintyMeasurements = -1;
            this.maximumUncertaintyMeasurements = -1;
        } else {
            this.count = -1L;
            this.duration = 0L;
            this.durationUnits = null;
            this.targetUncertainty = Double.parseDouble(uncertainty.uncertainty.value());
            this.minimumUncertaintyMeasurements = Integer.parseInt(uncertainty.minMeasurements.value());
            this.maximumUncertaintyMeasurements = Integer.parseInt(uncertainty.maxMeasurements.value());
        }
    }

    public abstract void truncateTables(StressSettings var1);

    protected void truncateTables(StressSettings settings, String ks, String ... tables) {
        JavaDriverClient client = settings.getJavaDriverClient(false);
        assert (settings.command.truncate != TruncateWhen.NEVER);
        for (String table : tables) {
            String cql = String.format("TRUNCATE %s.%s", ks, table);
            client.execute(cql, ConsistencyLevel.ONE);
        }
        System.out.println(String.format("Truncated %s.%s. Sleeping %ss for propagation.", ks, Arrays.toString(tables), settings.node.nodes.size()));
        Uninterruptibles.sleepUninterruptibly((long)settings.node.nodes.size(), (TimeUnit)TimeUnit.SECONDS);
    }

    public void printSettings(ResultLogger out) {
        out.printf("  Type: %s%n", this.type.toString().toLowerCase());
        out.printf("  Count: %,d%n", this.count);
        if (this.durationUnits != null) {
            out.printf("  Duration: %,d %s%n", this.duration, this.durationUnits.toString());
        }
        out.printf("  No Warmup: %s%n", this.noWarmup);
        out.printf("  Consistency Level: %s%n", this.consistencyLevel.toString());
        if (this.targetUncertainty != -1.0) {
            out.printf("  Target Uncertainty: %.3f%n", this.targetUncertainty);
            out.printf("  Minimum Uncertainty Measurements: %,d%n", this.minimumUncertaintyMeasurements);
            out.printf("  Maximum Uncertainty Measurements: %,d%n", this.maximumUncertaintyMeasurements);
        } else {
            out.printf("  Target Uncertainty: not applicable%n", new Object[0]);
        }
    }

    static SettingsCommand get(Map<String, String[]> clArgs) {
        for (Command cmd : Command.values()) {
            if (cmd.category == null) continue;
            for (String name : cmd.names) {
                String[] params = clArgs.remove(name);
                if (params == null) continue;
                switch (cmd.category) {
                    case BASIC: {
                        return SettingsCommandPreDefined.build(cmd, params);
                    }
                    case MIXED: {
                        return SettingsCommandPreDefinedMixed.build(params);
                    }
                    case USER: {
                        return SettingsCommandUser.build(params);
                    }
                }
            }
        }
        return null;
    }

    static void printHelp(Command type) {
        SettingsCommand.printHelp(type.toString().toLowerCase());
    }

    static void printHelp(String type) {
        GroupedOptions.printOptions(System.out, type.toLowerCase(), new Uncertainty(), new Count(), new Duration());
    }

    static Runnable helpPrinter(final Command type) {
        return new Runnable(){

            @Override
            public void run() {
                SettingsCommand.printHelp(type);
            }
        };
    }

    static class Uncertainty
    extends Options {
        final OptionSimple uncertainty = new OptionSimple("err<", "0\\.[0-9]+", "0.02", "Run until the standard error of the mean is below this fraction", false);
        final OptionSimple minMeasurements = new OptionSimple("n>", "[0-9]+", "30", "Run at least this many iterations before accepting uncertainty convergence", false);
        final OptionSimple maxMeasurements = new OptionSimple("n<", "[0-9]+", "200", "Run at most this many iterations before accepting uncertainty convergence", false);

        Uncertainty() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.uncertainty, this.minMeasurements, this.maxMeasurements, this.noWarmup, this.truncate, this.consistencyLevel);
        }
    }

    static class Duration
    extends Options {
        final OptionSimple duration = new OptionSimple("duration=", "[0-9]+[smhd]", null, "Time to run in (in seconds, minutes, hours or days)", true);

        Duration() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.duration, this.noWarmup, this.truncate, this.consistencyLevel);
        }
    }

    static class Count
    extends Options {
        final OptionSimple count = new OptionSimple("n=", "[0-9]+[bmk]?", null, "Number of operations to perform", true);

        Count() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.count, this.noWarmup, this.truncate, this.consistencyLevel);
        }
    }

    static abstract class Options
    extends GroupedOptions {
        final OptionSimple noWarmup = new OptionSimple("no-warmup", "", null, "Do not warmup the process", false);
        final OptionSimple truncate = new OptionSimple("truncate=", "never|once|always", "never", "Truncate the table: never, before performing any work, or before each iteration", false);
        final OptionSimple consistencyLevel = new OptionSimple("cl=", "ONE|QUORUM|LOCAL_QUORUM|EACH_QUORUM|ALL|ANY|TWO|THREE|LOCAL_ONE|SERIAL|LOCAL_SERIAL", "LOCAL_ONE", "Consistency level to use", false);

        Options() {
        }
    }

    public static enum TruncateWhen {
        NEVER,
        ONCE,
        ALWAYS;

    }
}

