/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApproximateTime {
    private static final Logger logger = LoggerFactory.getLogger(ApproximateTime.class);
    private static final int ALMOST_NOW_UPDATE_INTERVAL_MS = Math.max(1, Integer.parseInt(System.getProperty("cassandra.approximate_time_precision_ms", "2")));
    private static final String CONVERSION_UPDATE_INTERVAL_PROPERTY = "cassandra.NANOTIMETOMILLIS_TIMESTAMP_UPDATE_INTERVAL";
    private static final long ALMOST_SAME_TIME_UPDATE_INTERVAL_MS = Long.getLong("cassandra.NANOTIMETOMILLIS_TIMESTAMP_UPDATE_INTERVAL", 10000L);
    private static volatile Future<?> almostNowUpdater;
    private static volatile Future<?> almostSameTimeUpdater;
    private static volatile long almostNowMillis;
    private static volatile long almostNowNanos;
    private static volatile AlmostSameTime almostSameTime;
    private static double failedAlmostSameTimeUpdateModifier;
    private static final Runnable refreshAlmostNow;
    private static final Runnable refreshAlmostSameTime;

    public static synchronized void stop(Measurement measurement) {
        switch (measurement) {
            case ALMOST_NOW: {
                almostNowUpdater.cancel(true);
                try {
                    almostNowUpdater.get();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                almostNowUpdater = null;
                break;
            }
            case ALMOST_SAME_TIME: {
                almostSameTimeUpdater.cancel(true);
                try {
                    almostSameTimeUpdater.get();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                almostSameTimeUpdater = null;
            }
        }
    }

    public static synchronized void start(Measurement measurement) {
        switch (measurement) {
            case ALMOST_NOW: {
                if (almostNowUpdater != null) {
                    throw new IllegalStateException("Already running");
                }
                refreshAlmostNow.run();
                logger.info("Scheduling approximate time-check task with a precision of {} milliseconds", (Object)ALMOST_NOW_UPDATE_INTERVAL_MS);
                almostNowUpdater = ScheduledExecutors.scheduledFastTasks.scheduleWithFixedDelay(refreshAlmostNow, ALMOST_NOW_UPDATE_INTERVAL_MS, ALMOST_NOW_UPDATE_INTERVAL_MS, TimeUnit.MILLISECONDS);
                break;
            }
            case ALMOST_SAME_TIME: {
                if (almostSameTimeUpdater != null) {
                    throw new IllegalStateException("Already running");
                }
                refreshAlmostSameTime.run();
                logger.info("Scheduling approximate time conversion task with an interval of {} milliseconds", (Object)ALMOST_SAME_TIME_UPDATE_INTERVAL_MS);
                almostSameTimeUpdater = ScheduledExecutors.scheduledFastTasks.scheduleWithFixedDelay(refreshAlmostSameTime, ALMOST_SAME_TIME_UPDATE_INTERVAL_MS, ALMOST_SAME_TIME_UPDATE_INTERVAL_MS, TimeUnit.MILLISECONDS);
            }
        }
    }

    @VisibleForTesting
    public static synchronized void refresh(Measurement measurement) {
        ApproximateTime.stop(measurement);
        ApproximateTime.start(measurement);
    }

    public static long currentTimeMillis() {
        return almostNowMillis;
    }

    public static long nanoTime() {
        return almostNowNanos;
    }

    static {
        almostSameTime = new AlmostSameTime(0L, 0L, Long.MAX_VALUE);
        failedAlmostSameTimeUpdateModifier = 1.0;
        refreshAlmostNow = () -> {
            almostNowMillis = System.currentTimeMillis();
            almostNowNanos = System.nanoTime();
        };
        refreshAlmostSameTime = () -> {
            int tries = 3;
            long[] samples = new long[7];
            samples[0] = System.nanoTime();
            for (int i = 1; i < samples.length; i += 2) {
                samples[i] = System.currentTimeMillis();
                samples[i + 1] = System.nanoTime();
            }
            int best = 1;
            for (int i = 3; i < samples.length - 1; i += 2) {
                if (samples[i + 1] - samples[i - 1] >= samples[best + 1] - samples[best - 1]) continue;
                best = i;
            }
            long millis = samples[best];
            long nanos = samples[best + 1] / 2L + samples[best - 1] / 2L;
            long error = samples[best + 1] / 2L - samples[best - 1] / 2L;
            AlmostSameTime prev = almostSameTime;
            AlmostSameTime next = new AlmostSameTime(millis, nanos, error);
            if (next.error > prev.error && (double)next.error > (double)prev.error * failedAlmostSameTimeUpdateModifier) {
                failedAlmostSameTimeUpdateModifier *= 1.1;
                return;
            }
            failedAlmostSameTimeUpdateModifier = 1.0;
            almostSameTime = next;
        };
        ApproximateTime.start(Measurement.ALMOST_NOW);
        ApproximateTime.start(Measurement.ALMOST_SAME_TIME);
    }

    public static enum Measurement {
        ALMOST_NOW,
        ALMOST_SAME_TIME;

    }

    public static class AlmostSameTime {
        final long millis;
        final long nanos;
        final long error;

        private AlmostSameTime(long millis, long nanos, long error) {
            this.millis = millis;
            this.nanos = nanos;
            this.error = error;
        }

        public long toCurrentTimeMillis(long nanoTime) {
            return this.millis + TimeUnit.NANOSECONDS.toMillis(nanoTime - this.nanos);
        }

        public long toNanoTime(long currentTimeMillis) {
            return this.nanos + TimeUnit.MILLISECONDS.toNanos(currentTimeMillis - this.millis);
        }
    }
}

