/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads;

import com.codahale.metrics.Snapshot;
import com.google.common.base.Objects;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.service.reads.SpeculativeRetryPolicy;

public class PercentileSpeculativeRetryPolicy
implements SpeculativeRetryPolicy {
    public static final PercentileSpeculativeRetryPolicy NINETY_NINE_P = new PercentileSpeculativeRetryPolicy(99.0);
    private static final Pattern PATTERN = Pattern.compile("^(?<val>[0-9.]+)p(ercentile)?$", 2);
    private static final DecimalFormat FORMATTER = new DecimalFormat("#.####", new DecimalFormatSymbols(Locale.ENGLISH));
    private final double percentile;

    public PercentileSpeculativeRetryPolicy(double percentile) {
        this.percentile = percentile;
    }

    @Override
    public long calculateThreshold(Snapshot latency, long existingValue) {
        if (latency.size() <= 0) {
            return existingValue;
        }
        return (long)latency.getValue(this.percentile / 100.0);
    }

    @Override
    public SpeculativeRetryPolicy.Kind kind() {
        return SpeculativeRetryPolicy.Kind.PERCENTILE;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PercentileSpeculativeRetryPolicy)) {
            return false;
        }
        PercentileSpeculativeRetryPolicy rhs = (PercentileSpeculativeRetryPolicy)obj;
        return this.percentile == rhs.percentile;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.kind(), this.percentile});
    }

    public String toString() {
        return String.format("%sp", FORMATTER.format(this.percentile));
    }

    static PercentileSpeculativeRetryPolicy fromString(String str) {
        double percentile;
        Matcher matcher = PATTERN.matcher(str);
        if (!matcher.matches()) {
            throw new IllegalArgumentException();
        }
        String val = matcher.group("val");
        try {
            percentile = Double.parseDouble(val);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(String.format("Invalid value %s for option '%s'", new Object[]{str, TableParams.Option.SPECULATIVE_RETRY}));
        }
        if (percentile <= 0.0 || percentile >= 100.0) {
            throw new ConfigurationException(String.format("Invalid value %s for PERCENTILE option '%s': must be between (0.0 and 100.0)", new Object[]{str, TableParams.Option.SPECULATIVE_RETRY}));
        }
        return new PercentileSpeculativeRetryPolicy(percentile);
    }

    static boolean stringMatches(String str) {
        return PATTERN.matcher(str).matches();
    }
}

