/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.util.Memory;
import org.apache.cassandra.utils.vint.VIntCoding;

public interface DataOutputPlus
extends DataOutput {
    public void write(ByteBuffer var1) throws IOException;

    default public void write(Memory memory, long offset, long length) throws IOException {
        for (ByteBuffer buffer : memory.asByteBuffers(offset, length)) {
            this.write(buffer);
        }
    }

    default public void writeVInt(long i) throws IOException {
        VIntCoding.writeVInt(i, this);
    }

    default public void writeUnsignedVInt(long i) throws IOException {
        VIntCoding.writeUnsignedVInt(i, this);
    }

    default public long position() {
        throw new UnsupportedOperationException();
    }

    default public boolean hasPosition() {
        return false;
    }
}

