/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.plan;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.sasi.SASIIndex;
import org.apache.cassandra.index.sasi.SSTableIndex;
import org.apache.cassandra.index.sasi.TermIterator;
import org.apache.cassandra.index.sasi.conf.ColumnIndex;
import org.apache.cassandra.index.sasi.conf.view.View;
import org.apache.cassandra.index.sasi.disk.Token;
import org.apache.cassandra.index.sasi.exceptions.TimeQuotaExceededException;
import org.apache.cassandra.index.sasi.plan.Expression;
import org.apache.cassandra.index.sasi.plan.Operation;
import org.apache.cassandra.index.sasi.utils.RangeIntersectionIterator;
import org.apache.cassandra.index.sasi.utils.RangeIterator;
import org.apache.cassandra.index.sasi.utils.RangeUnionIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.Pair;

public class QueryController {
    private final long executionQuota;
    private final long executionStart;
    private final ColumnFamilyStore cfs;
    private final PartitionRangeReadCommand command;
    private final DataRange range;
    private final Map<Collection<Expression>, List<RangeIterator<Long, Token>>> resources = new HashMap<Collection<Expression>, List<RangeIterator<Long, Token>>>();

    public QueryController(ColumnFamilyStore cfs, PartitionRangeReadCommand command, long timeQuotaMs) {
        this.cfs = cfs;
        this.command = command;
        this.range = command.dataRange();
        this.executionQuota = TimeUnit.MILLISECONDS.toNanos(timeQuotaMs);
        this.executionStart = System.nanoTime();
    }

    public TableMetadata metadata() {
        return this.command.metadata();
    }

    public Collection<RowFilter.Expression> getExpressions() {
        return this.command.rowFilter().getExpressions();
    }

    public DataRange dataRange() {
        return this.command.dataRange();
    }

    public AbstractType<?> getKeyValidator() {
        return this.cfs.metadata().partitionKeyType;
    }

    public ColumnIndex getIndex(RowFilter.Expression expression) {
        Optional<Index> index = this.cfs.indexManager.getBestIndexFor(expression);
        return index.isPresent() ? ((SASIIndex)index.get()).getIndex() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnfilteredRowIterator getPartition(DecoratedKey key, ReadExecutionController executionController) {
        if (key == null) {
            throw new NullPointerException();
        }
        try {
            SinglePartitionReadCommand partition = SinglePartitionReadCommand.create(this.cfs.metadata(), this.command.nowInSec(), this.command.columnFilter(), this.command.rowFilter().withoutExpressions(), DataLimits.NONE, key, this.command.clusteringIndexFilter(key));
            UnfilteredRowIterator unfilteredRowIterator = partition.queryMemtableAndDisk(this.cfs, executionController);
            return unfilteredRowIterator;
        }
        finally {
            this.checkpoint();
        }
    }

    public RangeIterator.Builder<Long, Token> getIndexes(Operation.OperationType op, Collection<Expression> expressions) {
        if (this.resources.containsKey(expressions)) {
            throw new IllegalArgumentException("Can't process the same expressions multiple times.");
        }
        RangeUnionIterator.Builder<Long, Token> builder = op == Operation.OperationType.OR ? RangeUnionIterator.builder() : RangeIntersectionIterator.builder();
        Set<Map.Entry<Expression, Set<SSTableIndex>>> view = this.getView(op, expressions).entrySet();
        ArrayList<TermIterator> perIndexUnions = new ArrayList<TermIterator>(view.size());
        for (Map.Entry<Expression, Set<SSTableIndex>> e : view) {
            TermIterator index = TermIterator.build(e.getKey(), e.getValue());
            builder.add(index);
            perIndexUnions.add(index);
        }
        this.resources.put(expressions, perIndexUnions);
        return builder;
    }

    public void checkpoint() {
        long executionTime = System.nanoTime() - this.executionStart;
        if (executionTime >= this.executionQuota) {
            throw new TimeQuotaExceededException("Command '" + this.command + "' took too long (" + TimeUnit.NANOSECONDS.toMillis(executionTime) + " >= " + TimeUnit.NANOSECONDS.toMillis(this.executionQuota) + "ms).");
        }
    }

    public void releaseIndexes(Operation operation) {
        if (operation.expressions != null) {
            this.releaseIndexes(this.resources.remove(operation.expressions.values()));
        }
    }

    private void releaseIndexes(List<RangeIterator<Long, Token>> indexes) {
        if (indexes == null) {
            return;
        }
        indexes.forEach(FileUtils::closeQuietly);
    }

    public void finish() {
        this.resources.values().forEach(this::releaseIndexes);
    }

    private Map<Expression, Set<SSTableIndex>> getView(Operation.OperationType op, Collection<Expression> expressions) {
        Pair<Expression, Set<SSTableIndex>> primary = op == Operation.OperationType.AND ? this.calculatePrimary(expressions) : null;
        HashMap<Expression, Set<SSTableIndex>> indexes = new HashMap<Expression, Set<SSTableIndex>>();
        for (Expression e : expressions) {
            if (!e.isIndexed() || e.getOp() == Expression.Op.NOT_EQ) continue;
            if (primary != null && e.equals(primary.left)) {
                indexes.put((Expression)primary.left, (Set<SSTableIndex>)primary.right);
                continue;
            }
            View view = e.index.getView();
            if (view == null) continue;
            HashSet<SSTableIndex> readers = new HashSet<SSTableIndex>();
            if (primary != null && ((Set)primary.right).size() > 0) {
                for (SSTableIndex index : (Set)primary.right) {
                    readers.addAll(view.match(index.minKey(), index.maxKey()));
                }
            } else {
                readers.addAll(this.applyScope(view.match(e)));
            }
            indexes.put(e, readers);
        }
        return indexes;
    }

    private Pair<Expression, Set<SSTableIndex>> calculatePrimary(Collection<Expression> expressions) {
        Expression expression = null;
        Set<Object> primaryIndexes = Collections.emptySet();
        for (Expression e : expressions) {
            View view;
            if (!e.isIndexed() || (view = e.index.getView()) == null) continue;
            Set<SSTableIndex> indexes = this.applyScope(view.match(e));
            if (expression != null && primaryIndexes.size() <= indexes.size()) continue;
            primaryIndexes = indexes;
            expression = e;
        }
        return expression == null ? null : Pair.create(expression, primaryIndexes);
    }

    private Set<SSTableIndex> applyScope(Set<SSTableIndex> indexes) {
        return Sets.filter(indexes, index -> {
            SSTableReader sstable = index.getSSTable();
            return this.range.startKey().compareTo(sstable.last) <= 0 && (this.range.stopKey().isMinimum() || sstable.first.compareTo(this.range.stopKey()) <= 0);
        });
    }
}

