/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.carbondata.core.scan.expression;

import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;

@InterfaceAudience.Internal
public class MatchExpression extends Expression {
  private String queryString;
  private int maxDoc;

  public MatchExpression(String queryString) {
    this.queryString = queryString;
    this.maxDoc = -1;
  }

  public MatchExpression(String queryString, int maxDoc) {
    this.queryString = queryString;
    this.maxDoc = maxDoc;
  }

  public int getMaxDoc() {
    return maxDoc;
  }

  @Override
  public ExpressionResult evaluate(RowIntf value) {
    return new ExpressionResult(DataTypes.BOOLEAN, true);
  }

  @Override
  public ExpressionType getFilterExpressionType() {
    return ExpressionType.TEXT_MATCH;
  }

  @Override
  public void findAndSetChild(Expression oldExpr, Expression newExpr) {

  }

  @Override
  public String getString() {
    return queryString;
  }

  @Override
  public String getStatement() {
    return "TEXT_MATCH('" + queryString + "')";
  }
}
