/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	camelv1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// IntegrationPlatformLister helps list IntegrationPlatforms.
// All objects returned here must be treated as read-only.
type IntegrationPlatformLister interface {
	// List lists all IntegrationPlatforms in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*camelv1.IntegrationPlatform, err error)
	// IntegrationPlatforms returns an object that can list and get IntegrationPlatforms.
	IntegrationPlatforms(namespace string) IntegrationPlatformNamespaceLister
	IntegrationPlatformListerExpansion
}

// integrationPlatformLister implements the IntegrationPlatformLister interface.
type integrationPlatformLister struct {
	listers.ResourceIndexer[*camelv1.IntegrationPlatform]
}

// NewIntegrationPlatformLister returns a new IntegrationPlatformLister.
func NewIntegrationPlatformLister(indexer cache.Indexer) IntegrationPlatformLister {
	return &integrationPlatformLister{listers.New[*camelv1.IntegrationPlatform](indexer, camelv1.Resource("integrationplatform"))}
}

// IntegrationPlatforms returns an object that can list and get IntegrationPlatforms.
func (s *integrationPlatformLister) IntegrationPlatforms(namespace string) IntegrationPlatformNamespaceLister {
	return integrationPlatformNamespaceLister{listers.NewNamespaced[*camelv1.IntegrationPlatform](s.ResourceIndexer, namespace)}
}

// IntegrationPlatformNamespaceLister helps list and get IntegrationPlatforms.
// All objects returned here must be treated as read-only.
type IntegrationPlatformNamespaceLister interface {
	// List lists all IntegrationPlatforms in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*camelv1.IntegrationPlatform, err error)
	// Get retrieves the IntegrationPlatform from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*camelv1.IntegrationPlatform, error)
	IntegrationPlatformNamespaceListerExpansion
}

// integrationPlatformNamespaceLister implements the IntegrationPlatformNamespaceLister
// interface.
type integrationPlatformNamespaceLister struct {
	listers.ResourceIndexer[*camelv1.IntegrationPlatform]
}
