/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
	camelv1 "github.com/apache/camel-k/v2/pkg/client/camel/applyconfiguration/camel/v1"
	typedcamelv1 "github.com/apache/camel-k/v2/pkg/client/camel/clientset/versioned/typed/camel/v1"
	gentype "k8s.io/client-go/gentype"
)

// fakeKamelets implements KameletInterface
type fakeKamelets struct {
	*gentype.FakeClientWithListAndApply[*v1.Kamelet, *v1.KameletList, *camelv1.KameletApplyConfiguration]
	Fake *FakeCamelV1
}

func newFakeKamelets(fake *FakeCamelV1, namespace string) typedcamelv1.KameletInterface {
	return &fakeKamelets{
		gentype.NewFakeClientWithListAndApply[*v1.Kamelet, *v1.KameletList, *camelv1.KameletApplyConfiguration](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("kamelets"),
			v1.SchemeGroupVersion.WithKind("Kamelet"),
			func() *v1.Kamelet { return &v1.Kamelet{} },
			func() *v1.KameletList { return &v1.KameletList{} },
			func(dst, src *v1.KameletList) { dst.ListMeta = src.ListMeta },
			func(list *v1.KameletList) []*v1.Kamelet { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.KameletList, items []*v1.Kamelet) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
