/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.mgmt.SubscriptionHandle;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.test.Asserts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityAsserts {
    private static final Logger LOG = LoggerFactory.getLogger(EntityAsserts.class);

    public static <T> void assertAttributeEquals(Entity entity, AttributeSensor<T> attribute, T expected) {
        Asserts.assertEquals((Object)entity.getAttribute(attribute), expected, (String)("entity=" + entity + "; attribute=" + attribute));
    }

    public static <T> void assertConfigEquals(Entity entity, ConfigKey<T> configKey, T expected) {
        Asserts.assertEquals((Object)entity.getConfig(configKey), expected, (String)("entity=" + entity + "; configKey=" + configKey));
    }

    public static <T> void assertAttributeEqualsEventually(Entity entity, AttributeSensor<T> attribute, T expected) {
        EntityAsserts.assertAttributeEqualsEventually(Maps.newLinkedHashMap(), entity, attribute, expected);
    }

    public static <T> void assertAttributeEqualsEventually(Map<?, ?> flags, final Entity entity, final AttributeSensor<T> attribute, final T expected) {
        Asserts.succeedsEventually(EntityAsserts.castToMapWithStringKeys(flags), (Runnable)new Runnable(){

            @Override
            public void run() {
                EntityAsserts.assertAttributeEquals(entity, attribute, expected);
            }
        });
    }

    public static <T> T assertAttributeEventuallyNonNull(Entity entity, AttributeSensor<T> attribute) {
        return EntityAsserts.assertAttributeEventuallyNonNull(Maps.newLinkedHashMap(), entity, attribute);
    }

    public static <T> T assertAttributeEventuallyNonNull(Map<?, ?> flags, Entity entity, AttributeSensor<T> attribute) {
        return EntityAsserts.assertAttributeEventually(flags, entity, attribute, Predicates.notNull());
    }

    public static <T> T assertAttributeEventually(Entity entity, AttributeSensor<T> attribute, Predicate<? super T> predicate) {
        return EntityAsserts.assertAttributeEventually(ImmutableMap.of(), entity, attribute, predicate);
    }

    public static <T> T assertAttributeEventually(Map<?, ?> flags, final Entity entity, final AttributeSensor<T> attribute, final Predicate<? super T> predicate) {
        final AtomicReference result = new AtomicReference();
        Asserts.succeedsEventually(EntityAsserts.castToMapWithStringKeys(flags), (Runnable)new Runnable(){

            @Override
            public void run() {
                Object val = EntityAsserts.assertAttribute(entity, attribute, predicate);
                result.set(val);
            }
        });
        return (T)result.get();
    }

    public static <T> T assertAttribute(Entity entity, AttributeSensor<T> attribute, Predicate<? super T> predicate) {
        Object val = entity.getAttribute(attribute);
        Asserts.assertTrue((boolean)predicate.apply(val), (String)("attribute=" + attribute + "; val=" + val));
        return (T)val;
    }

    public static <T extends Entity> void assertPredicateEventuallyTrue(T entity, Predicate<? super T> predicate) {
        EntityAsserts.assertPredicateEventuallyTrue(ImmutableMap.of(), entity, predicate);
    }

    public static <T extends Entity> void assertPredicateEventuallyTrue(Map<?, ?> flags, final T entity, final Predicate<? super T> predicate) {
        Asserts.succeedsEventually(EntityAsserts.castToMapWithStringKeys(flags), (Runnable)new Runnable(){

            @Override
            public void run() {
                Asserts.assertTrue((boolean)predicate.apply((Object)entity), (String)("predicate " + predicate + " unsatisfied for " + entity));
            }
        });
    }

    public static <T> void assertAttributeEqualsContinually(Entity entity, AttributeSensor<T> attribute, T expected) {
        EntityAsserts.assertAttributeEqualsContinually(ImmutableMap.of(), entity, attribute, expected);
    }

    public static <T> void assertAttributeEqualsContinually(Map<?, ?> flags, final Entity entity, final AttributeSensor<T> attribute, final T expected) {
        Asserts.succeedsContinually(flags, (Runnable)new Runnable(){

            @Override
            public void run() {
                EntityAsserts.assertAttributeEquals(entity, attribute, expected);
            }
        });
    }

    public static void assertGroupSizeEqualsEventually(Group group, int expected) {
        EntityAsserts.assertGroupSizeEqualsEventually(ImmutableMap.of(), group, expected);
    }

    public static void assertGroupSizeEqualsEventually(Map<?, ?> flags, final Group group, final int expected) {
        Asserts.succeedsEventually(EntityAsserts.castToMapWithStringKeys(flags), (Runnable)new Runnable(){

            @Override
            public void run() {
                Collection members = group.getMembers();
                Asserts.assertEquals((int)members.size(), (int)expected, (String)("members=" + members));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertAttributeChangesEventually(final Entity entity, final AttributeSensor<?> attribute) {
        final Object origValue = entity.getAttribute(attribute);
        final AtomicBoolean changed = new AtomicBoolean();
        SubscriptionHandle handle = entity.subscriptions().subscribe(entity, attribute, (SensorEventListener)new SensorEventListener<Object>(){

            public void onEvent(SensorEvent<Object> event) {
                if (!Objects.equal((Object)origValue, (Object)event.getValue())) {
                    changed.set(true);
                }
            }
        });
        try {
            Asserts.succeedsEventually((Runnable)new Runnable(){

                @Override
                public void run() {
                    Asserts.assertTrue((boolean)changed.get(), (String)(entity + " -> " + attribute + " not changed from " + origValue));
                }
            });
        }
        finally {
            entity.subscriptions().unsubscribe(entity, handle);
        }
    }

    @SafeVarargs
    @Beta
    public static <T> void assertAttributeContinuallyNotEqualTo(final Entity entity, final AttributeSensor<T> attribute, T ... disallowed) {
        final HashSet reject = Sets.newHashSet((Object[])disallowed);
        Asserts.succeedsContinually((Runnable)new Runnable(){

            @Override
            public void run() {
                Object val = entity.getAttribute(attribute);
                Asserts.assertFalse((boolean)reject.contains(val), (String)("Attribute " + attribute + " on " + entity + " has disallowed value " + val));
            }
        });
    }

    @SafeVarargs
    @Beta
    public static <T> void assertAttributeContinuallyNotEqualTo(Map<?, ?> flags, final Entity entity, final AttributeSensor<T> attribute, T ... disallowed) {
        final HashSet reject = Sets.newHashSet((Object[])disallowed);
        Asserts.succeedsContinually(flags, (Runnable)new Runnable(){

            @Override
            public void run() {
                Object val = entity.getAttribute(attribute);
                Asserts.assertFalse((boolean)reject.contains(val), (String)("Attribute " + attribute + " on " + entity + " has disallowed value " + val));
            }
        });
    }

    public static void assertEntityHealthy(Entity entity) {
        EntityAsserts.assertAttributeEquals(entity, Startable.SERVICE_UP, true);
        EntityAsserts.assertAttributeEquals(entity, Attributes.SERVICE_STATE_ACTUAL, Lifecycle.RUNNING);
        EntityAsserts.assertAttribute(entity, Attributes.SERVICE_STATE_EXPECTED, new Predicate<Lifecycle.Transition>(){

            public boolean apply(Lifecycle.Transition transition) {
                Asserts.assertNotNull((Object)transition);
                return Lifecycle.RUNNING.equals((Object)transition.getState());
            }
        });
    }

    public static void assertEntityHealthyEventually(Entity entity) {
        Asserts.succeedsEventually(() -> EntityAsserts.assertEntityHealthy(entity));
    }

    @Beta
    public static void assertEntityFailed(Entity entity) {
        EntityAsserts.assertAttributeEquals(entity, Startable.SERVICE_UP, false);
        EntityAsserts.assertAttributeEquals(entity, Attributes.SERVICE_STATE_ACTUAL, Lifecycle.ON_FIRE);
    }

    private static Map<String, ?> castToMapWithStringKeys(Map<?, ?> map) {
        if (map == null) {
            return ImmutableMap.of();
        }
        for (Object key : map.keySet()) {
            if (key instanceof String) continue;
            IllegalArgumentException e = new IllegalArgumentException("Invalid non-string key(s), type " + key.getClass().getName() + " in map");
            e.fillInStackTrace();
            LOG.warn("Deprecated: invalid key(s) in map (continuing)", (Throwable)e);
            break;
        }
        return map;
    }
}

