/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.apis;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import org.jclouds.View;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.ApiPredicates;
import org.jclouds.osgi.ApiRegistry;
import org.jclouds.reflect.Reflection2;
import org.jclouds.util.TypeTokenUtils;

public class Apis {
    public static Function<ApiMetadata, String> idFunction() {
        return IdFunction.INSTANCE;
    }

    private static Iterable<ApiMetadata> fromServiceLoader() {
        return ServiceLoader.load(ApiMetadata.class);
    }

    public static Iterable<ApiMetadata> all() {
        return ImmutableSet.builder().addAll(Apis.fromServiceLoader()).addAll(ApiRegistry.fromRegistry()).build();
    }

    public static ApiMetadata withId(String id) throws NoSuchElementException {
        return (ApiMetadata)Iterables.find(Apis.all(), ApiPredicates.id(id));
    }

    public static Iterable<ApiMetadata> contextAssignableFrom(TypeToken<?> type) {
        return Iterables.filter(Apis.all(), ApiPredicates.contextAssignableFrom(type));
    }

    public static Iterable<ApiMetadata> viewableAs(TypeToken<? extends View> type) {
        return Iterables.filter(Apis.all(), ApiPredicates.viewableAs(type));
    }

    public static Iterable<ApiMetadata> viewableAs(Class<? extends View> type) {
        return Iterables.filter(Apis.all(), ApiPredicates.viewableAs(Reflection2.typeToken(type)));
    }

    public static TypeToken<?> findView(ApiMetadata apiMetadata, final TypeToken<?> view) throws NoSuchElementException {
        Preconditions.checkNotNull((Object)apiMetadata, (Object)"apiMetadata must be defined");
        Preconditions.checkNotNull(view, (Object)"context must be defined");
        return (TypeToken)Iterables.find(apiMetadata.getViews(), (Predicate)new Predicate<TypeToken<?>>(){

            public boolean apply(TypeToken<?> input) {
                return TypeTokenUtils.isSupertypeOf(view, input);
            }
        });
    }

    private static enum IdFunction implements Function<ApiMetadata, String>
    {
        INSTANCE;


        public String apply(ApiMetadata input) {
            return input.getId();
        }
    }
}

