/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.creation;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.camp.brooklyn.spi.creation.CampResolver;
import org.apache.brooklyn.core.typereg.AbstractFormatSpecificTypeImplementationPlan;
import org.apache.brooklyn.core.typereg.AbstractTypePlanTransformer;
import org.apache.brooklyn.core.typereg.BasicTypeImplementationPlan;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;

public class CampTypePlanTransformer
extends AbstractTypePlanTransformer {
    private static final List<String> FORMATS = ImmutableList.of((Object)"brooklyn-camp");
    public static final String FORMAT = FORMATS.get(0);

    public CampTypePlanTransformer() {
        super(FORMAT, "OASIS CAMP / Brooklyn", "The Apache Brooklyn implementation of the OASIS CAMP blueprint plan format and extensions");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected double scoreForNullFormat(Object planData, RegisteredType type, RegisteredTypeLoadingContext context) {
        double weight;
        if (type != null) {
            if (type.getKind() == BrooklynTypeRegistry.RegisteredTypeKind.SPEC) {
                weight = 1.0;
            } else {
                if (type.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED) return 0.0;
                weight = 0.4;
            }
        } else {
            weight = 0.8;
        }
        Maybe plan = RegisteredTypes.getAsYamlMap((Object)planData);
        if (plan.isPresent()) {
            return weight * this.scoreObject(plan.get(), (map, s) -> map.containsKey(s));
        }
        if (planData == null) {
            return 0.0;
        }
        double unparseableScore = this.scoreObject(planData.toString(), (p, s) -> p.contains((CharSequence)s));
        if (!(unparseableScore > 0.0)) return 0.0;
        return 0.5 + 0.25 * unparseableScore;
    }

    protected <T> double scoreObject(T plan, BiFunction<T, String, Boolean> contains) {
        if (contains.apply(plan, "services").booleanValue()) {
            return 0.8;
        }
        if (contains.apply(plan, "type").booleanValue()) {
            return 0.4;
        }
        if (contains.apply(plan, "brooklyn.locations").booleanValue()) {
            return 0.7;
        }
        if (contains.apply(plan, "brooklyn.policies").booleanValue()) {
            return 0.7;
        }
        if (contains.apply(plan, "brooklyn.enrichers").booleanValue()) {
            return 0.7;
        }
        if (contains.apply(plan, "catalog.bom").booleanValue()) {
            return 0.2;
        }
        return 0.0;
    }

    protected double scoreForNonmatchingNonnullFormat(String planFormat, Object planData, RegisteredType type, RegisteredTypeLoadingContext context) {
        if (type != null && type.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.SPEC) {
            return 0.0;
        }
        if (FORMATS.contains(planFormat.toLowerCase())) {
            return 0.9;
        }
        return 0.0;
    }

    protected AbstractBrooklynObjectSpec<?, ?> createSpec(RegisteredType type, RegisteredTypeLoadingContext context) throws Exception {
        try {
            return new CampResolver(this.mgmt, type, context).createSpec();
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            String message = null;
            if (type == null || type.getPlan() == null || type.getPlan().getPlanData() == null) {
                message = "Type/plan/data is null when resolving CAMP blueprint";
            } else {
                Object planData = type.getPlan().getPlanData();
                if (RegisteredTypes.getAsYamlMap((Object)planData).isAbsent()) {
                    message = "Type or plan is invalid YAML when resolving CAMP blueprint";
                } else if (planData.toString().contains("brooklyn.catalog")) {
                    message = "CAMP blueprint for type definition looks like a catalog file";
                }
            }
            if (message != null) {
                throw Exceptions.propagateAnnotated((String)message, (Throwable)e);
            }
            throw e;
        }
    }

    protected Object createBean(RegisteredType type, RegisteredTypeLoadingContext context) throws Exception {
        throw new IllegalStateException("beans not supported here");
    }

    public double scoreForTypeDefinition(String formatCode, Object catalogData) {
        return 0.0;
    }

    public List<RegisteredType> createFromTypeDefinition(String formatCode, Object catalogData) {
        return null;
    }

    public static class CampTypeImplementationPlan
    extends AbstractFormatSpecificTypeImplementationPlan<String> {
        public CampTypeImplementationPlan(RegisteredType.TypeImplementationPlan otherPlan) {
            super((String)FORMATS.get(0), String.class, otherPlan);
        }

        public CampTypeImplementationPlan(String planData) {
            this((RegisteredType.TypeImplementationPlan)new BasicTypeImplementationPlan((String)FORMATS.get(0), (Object)planData));
        }
    }
}

