/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.jclouds.aws.ec2.compute.functions.PresentSpotRequestsAndInstances;
import org.jclouds.aws.ec2.compute.strategy.CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions;
import org.jclouds.aws.ec2.domain.LaunchSpecification;
import org.jclouds.aws.ec2.features.SpotInstanceApi;
import org.jclouds.aws.ec2.functions.SpotInstanceRequestToAWSRunningInstance;
import org.jclouds.aws.ec2.options.AWSRunInstancesOptions;
import org.jclouds.aws.ec2.options.RequestSpotInstancesOptions;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.util.ComputeUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.PresentInstances;
import org.jclouds.ec2.compute.strategy.CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions;
import org.jclouds.ec2.compute.strategy.EC2CreateNodesInGroupThenAddToSet;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.logging.Logger;

@Singleton
public class AWSEC2CreateNodesInGroupThenAddToSet
extends EC2CreateNodesInGroupThenAddToSet {
    @Resource
    @Named(value="jclouds.compute")
    private Logger logger = Logger.NULL;
    @VisibleForTesting
    private final AWSEC2Api client;
    private final SpotInstanceRequestToAWSRunningInstance spotConverter;

    @Inject
    protected AWSEC2CreateNodesInGroupThenAddToSet(AWSEC2Api client, @Named(value="ELASTICIP") LoadingCache<RegionAndName, String> elasticIpCache, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, @Named(value="jclouds.ec2.generate-instance-names") boolean generateInstanceNames, CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions createKeyPairAndSecurityGroupsAsNeededAndReturncustomize, PresentSpotRequestsAndInstances instancePresent, Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata, LoadingCache<RunningInstance, Optional<LoginCredentials>> instanceToCredentials, Map<String, Credentials> credentialStore, ComputeUtils utils, SpotInstanceRequestToAWSRunningInstance spotConverter) {
        super((EC2Api)client, elasticIpCache, nodeRunning, (CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions)createKeyPairAndSecurityGroupsAsNeededAndReturncustomize, (PresentInstances)instancePresent, runningInstanceToNodeMetadata, instanceToCredentials, credentialStore, utils);
        this.client = (AWSEC2Api)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.spotConverter = (SpotInstanceRequestToAWSRunningInstance)Preconditions.checkNotNull((Object)spotConverter, (Object)"spotConverter");
    }

    protected Set<RunningInstance> createNodesInRegionAndZone(String region, String zone, String group, int count, Template template, RunInstancesOptions instanceOptions) {
        Float spotPrice = this.getSpotPriceOrNull(template.getOptions());
        if (spotPrice != null) {
            AWSEC2TemplateOptions awsOptions = (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(template.getOptions());
            LaunchSpecification spec = ((AWSRunInstancesOptions)((Object)AWSRunInstancesOptions.class.cast(instanceOptions))).getLaunchSpecificationBuilder().imageId(template.getImage().getProviderId()).availabilityZone(zone).subnetId(awsOptions.getSubnetId()).iamInstanceProfileArn(awsOptions.getIAMInstanceProfileArn()).iamInstanceProfileName(awsOptions.getIAMInstanceProfileName()).build();
            RequestSpotInstancesOptions options = awsOptions.getSpotOptions();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(">> requesting %d spot instances region(%s) price(%f) spec(%s) options(%s)", new Object[]{count, region, spotPrice, spec, options});
            }
            return ImmutableSet.copyOf((Iterable)Iterables.transform(((SpotInstanceApi)this.client.getSpotInstanceApi().get()).requestSpotInstancesInRegion(region, spotPrice.floatValue(), count, spec, options), (Function)this.spotConverter));
        }
        return super.createNodesInRegionAndZone(region, zone, group, count, template, instanceOptions);
    }

    private Float getSpotPriceOrNull(TemplateOptions options) {
        return options instanceof AWSEC2TemplateOptions ? ((AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(options)).getSpotPrice() : null;
    }
}

