/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.enricher.stock;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.enricher.stock.Aggregator;
import org.apache.brooklyn.enricher.stock.Combiner;
import org.apache.brooklyn.enricher.stock.Joiner;
import org.apache.brooklyn.enricher.stock.MapAggregator;
import org.apache.brooklyn.enricher.stock.Propagator;
import org.apache.brooklyn.enricher.stock.Transformer;
import org.apache.brooklyn.enricher.stock.UpdatingMap;
import org.apache.brooklyn.enricher.stock.reducer.Reducer;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.core.flags.TypeCoercions;

public class Enrichers {
    private Enrichers() {
    }

    public static InitialBuilder builder() {
        return new InitialBuilder();
    }

    @Deprecated
    protected static <T extends Number> T average(Collection<T> vals, Number defaultValueForUnreportedSensors, Number valueToReportIfNoSensors, TypeToken<T> type) {
        Double doubleValueToReportIfNoSensors = valueToReportIfNoSensors == null ? null : Double.valueOf(valueToReportIfNoSensors.doubleValue());
        int count = Enrichers.count(vals, defaultValueForUnreportedSensors != null);
        Double result = count == 0 ? doubleValueToReportIfNoSensors : Double.valueOf((Double)Enrichers.sum(vals, defaultValueForUnreportedSensors, 0, TypeToken.of(Double.class)) / (double)count);
        return Enrichers.cast(result, type);
    }

    protected static <N extends Number> N cast(Number n, TypeToken<? extends N> numberType) {
        return (N)((Number)TypeCoercions.coerce((Object)n, numberType));
    }

    @Deprecated
    public static <N extends Number> N sum(Iterable<? extends Number> vals, Number valueIfNull, Number valueIfNone, TypeToken<N> type) {
        double result = 0.0;
        int count = 0;
        if (vals != null) {
            for (Number number : vals) {
                if (number != null) {
                    result += number.doubleValue();
                    ++count;
                    continue;
                }
                if (valueIfNull == null) continue;
                result += valueIfNull.doubleValue();
                ++count;
            }
        }
        if (count == 0) {
            return Enrichers.cast(valueIfNone, type);
        }
        return Enrichers.cast(result, type);
    }

    @Deprecated
    protected static int count(Iterable<? extends Object> vals, boolean includeNullValues) {
        int result = 0;
        if (vals != null) {
            for (Object object : vals) {
                if (object == null && !includeNullValues) continue;
                ++result;
            }
        }
        return result;
    }

    private static <T> Map<T, T> newIdentityMap(Set<T> keys) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (T key : keys) {
            result.put(key, key);
        }
        return result;
    }

    @Beta
    public static class ComputingIsQuorate<T>
    implements Function<Collection<Boolean>, Boolean> {
        protected final TypeToken<T> typeToken;
        protected final QuorumCheck quorumCheck;
        protected final int totalSize;

        public ComputingIsQuorate(TypeToken<T> typeToken, QuorumCheck quorumCheck, int totalSize) {
            this.quorumCheck = quorumCheck;
            this.totalSize = totalSize;
            if (typeToken != null && TypeToken.of(Boolean.class).isAssignableFrom(typeToken.getType())) {
                this.typeToken = typeToken;
            } else if (typeToken == null || typeToken.isAssignableFrom(Boolean.class)) {
                this.typeToken = TypeToken.of(Boolean.class);
            } else {
                throw new IllegalArgumentException("Type " + typeToken + " is not valid for " + this + " -- expected " + TypeToken.of(Boolean.class));
            }
        }

        public Boolean apply(Collection<Boolean> input) {
            int numTrue = 0;
            for (Boolean inputVal : input) {
                if (!Boolean.TRUE.equals(inputVal)) continue;
                ++numTrue;
            }
            return this.quorumCheck.isQuorate(numTrue, this.totalSize);
        }
    }

    @Deprecated
    public static class ComputingAverage<T extends Number>
    extends ComputingNumber<T> {
        public ComputingAverage(Number defaultValueForUnreportedSensors, Number valueToReportIfNoSensors, TypeToken<T> typeToken) {
            super(defaultValueForUnreportedSensors, valueToReportIfNoSensors, typeToken);
        }

        @Override
        public T apply(Collection<T> input) {
            return Enrichers.average(input, this.defaultValueForUnreportedSensors, this.valueToReportIfNoSensors, this.typeToken);
        }
    }

    @Deprecated
    public static class ComputingSum<T extends Number>
    extends ComputingNumber<T> {
        public ComputingSum(Number defaultValueForUnreportedSensors, Number valueToReportIfNoSensors, TypeToken<T> typeToken) {
            super(defaultValueForUnreportedSensors, valueToReportIfNoSensors, typeToken);
        }

        @Override
        public T apply(Collection<T> input) {
            return (T)Enrichers.sum(input, this.defaultValueForUnreportedSensors, this.valueToReportIfNoSensors, this.typeToken);
        }
    }

    @Deprecated
    private static abstract class ComputingNumber<T extends Number>
    implements Function<Collection<T>, T> {
        protected final Number defaultValueForUnreportedSensors;
        protected final Number valueToReportIfNoSensors;
        protected final TypeToken<T> typeToken;

        public ComputingNumber(Number defaultValueForUnreportedSensors, Number valueToReportIfNoSensors, TypeToken<T> typeToken) {
            this.defaultValueForUnreportedSensors = defaultValueForUnreportedSensors;
            this.valueToReportIfNoSensors = valueToReportIfNoSensors;
            if (typeToken != null && TypeToken.of(Number.class).isAssignableFrom(typeToken.getType())) {
                this.typeToken = typeToken;
            } else if (typeToken == null || typeToken.isAssignableFrom(Number.class)) {
                this.typeToken = TypeToken.of(Double.class);
            } else {
                throw new IllegalArgumentException("Type " + typeToken + " is not valid for " + this);
            }
        }

        public abstract T apply(Collection<T> var1);
    }

    public static class ReducerBuilder
    extends AbstractReducerBuilder<ReducerBuilder> {
        public ReducerBuilder(Class<? extends Reducer> clazz, List<AttributeSensor<?>> val) {
            super(clazz, val);
        }
    }

    public static class JoinerBuilder
    extends AbstractJoinerBuilder<JoinerBuilder> {
        public JoinerBuilder(AttributeSensor<?> source) {
            super(source);
        }
    }

    public static class UpdatingMapBuilder<S, TKey, TVal>
    extends AbstractUpdatingMapBuilder<S, TKey, TVal, UpdatingMapBuilder<S, TKey, TVal>> {
        public UpdatingMapBuilder(AttributeSensor<Map<TKey, TVal>> val) {
            super(val);
        }
    }

    public static class TransformerBuilder<S, T>
    extends AbstractTransformerBuilder<S, T, TransformerBuilder<S, T>> {
        public TransformerBuilder(AttributeSensor<S> val) {
            super(val);
        }
    }

    public static class CombinerBuilder<S, T>
    extends AbstractCombinerBuilder<S, T, CombinerBuilder<S, T>> {
        @SafeVarargs
        public CombinerBuilder(AttributeSensor<? extends S> ... vals) {
            super(vals);
        }

        public CombinerBuilder(Collection<AttributeSensor<? extends S>> vals) {
            super(vals);
        }
    }

    public static class PropagatorBuilder
    extends AbstractPropagatorBuilder<PropagatorBuilder> {
        public PropagatorBuilder(Map<? extends Sensor<?>, ? extends Sensor<?>> vals) {
            super(vals);
        }

        public PropagatorBuilder(Iterable<? extends Sensor<?>> vals) {
            super(vals);
        }

        public PropagatorBuilder(Sensor<?> ... vals) {
            super(vals);
        }

        PropagatorBuilder(boolean propagatingAll, Iterable<? extends Sensor<?>> butVals) {
            super(propagatingAll, butVals);
        }
    }

    public static class AggregatorBuilder<S, T>
    extends AbstractAggregatorBuilder<S, T, AggregatorBuilder<S, T>> {
        public AggregatorBuilder(AttributeSensor<S> aggregating) {
            super(aggregating);
        }

        public AggregatorBuilder(AttributeSensor<S> keySensor, AttributeSensor<S> valueSensor) {
            super(keySensor, valueSensor);
        }
    }

    public static class InitialBuilder
    extends AbstractInitialBuilder<InitialBuilder> {
    }

    protected static abstract class AbstractReducerBuilder<B extends AbstractReducerBuilder<B>>
    extends AbstractEnricherBuilder<B> {
        protected AttributeSensor<?> publishing;
        protected Entity fromEntity;
        protected List<AttributeSensor<?>> reducing;
        protected Function<? extends Iterable<?>, ?> computing;
        protected String functionName;
        private Map<String, Object> parameters;

        public AbstractReducerBuilder(Class<? extends Reducer> clazz, List<AttributeSensor<?>> val) {
            super((Class)Preconditions.checkNotNull(clazz));
            this.reducing = (List)Preconditions.checkNotNull(val);
        }

        public B publishing(AttributeSensor<?> val) {
            this.publishing = (AttributeSensor)Preconditions.checkNotNull(val);
            return (B)((AbstractReducerBuilder)this.self());
        }

        public B from(Entity val) {
            this.fromEntity = (Entity)Preconditions.checkNotNull((Object)val);
            return (B)((AbstractReducerBuilder)this.self());
        }

        public B computing(Function<? extends Iterable<?>, ?> val) {
            this.computing = (Function)Preconditions.checkNotNull(val);
            return (B)((AbstractReducerBuilder)this.self());
        }

        public B computing(String functionName) {
            return this.computing(functionName, (Map<String, Object>)ImmutableMap.of());
        }

        public B computing(String functionName, Map<String, Object> parameters) {
            this.functionName = functionName;
            this.parameters = parameters;
            return (B)((AbstractReducerBuilder)this.self());
        }

        @Override
        public EnricherSpec<?> build() {
            return (EnricherSpec)super.build().configure((Map)MutableMap.builder().put(Reducer.SOURCE_SENSORS, this.reducing).put(Reducer.PRODUCER, (Object)this.fromEntity).put(Reducer.TARGET_SENSOR, this.publishing).putIfNotNull(Reducer.REDUCER_FUNCTION, this.computing).putIfNotNull(Reducer.REDUCER_FUNCTION_TRANSFORMATION, (Object)this.functionName).putIfNotNull(Reducer.PARAMETERS, this.parameters).build());
        }

        @Override
        protected String getDefaultUniqueTag() {
            return "reducer:" + this.reducing.toString();
        }
    }

    protected static abstract class AbstractJoinerBuilder<B extends AbstractJoinerBuilder<B>>
    extends AbstractEnricherBuilder<B> {
        protected final AttributeSensor<?> transforming;
        protected AttributeSensor<String> publishing;
        protected Entity fromEntity;
        protected String separator;
        protected String keyValueSeparator;
        protected Boolean joinMapEntries;
        protected Boolean quote;
        protected Integer minimum;
        protected Integer maximum;

        public AbstractJoinerBuilder(AttributeSensor<?> source) {
            super(Joiner.class);
            this.transforming = (AttributeSensor)Preconditions.checkNotNull(source);
        }

        public B publishing(AttributeSensor<String> target) {
            this.publishing = (AttributeSensor)Preconditions.checkNotNull(target);
            return (B)((AbstractJoinerBuilder)this.self());
        }

        public B separator(String separator) {
            this.separator = separator;
            return (B)((AbstractJoinerBuilder)this.self());
        }

        public B keyValueSeparator(String keyValueSeparator) {
            this.keyValueSeparator = keyValueSeparator;
            return (B)((AbstractJoinerBuilder)this.self());
        }

        public B joinMapEntries(Boolean joinMapEntries) {
            this.joinMapEntries = joinMapEntries;
            return (B)((AbstractJoinerBuilder)this.self());
        }

        public B quote(Boolean quote) {
            this.quote = quote;
            return (B)((AbstractJoinerBuilder)this.self());
        }

        public B minimum(Integer minimum) {
            this.minimum = minimum;
            return (B)((AbstractJoinerBuilder)this.self());
        }

        public B maximum(Integer maximum) {
            this.maximum = maximum;
            return (B)((AbstractJoinerBuilder)this.self());
        }

        @Override
        protected String getDefaultUniqueTag() {
            if (this.transforming == null || this.publishing == null) {
                return null;
            }
            return "joiner:" + this.transforming.getName() + "->" + this.publishing.getName();
        }

        @Override
        public EnricherSpec<?> build() {
            return (EnricherSpec)super.build().configure((Map)MutableMap.builder().putIfNotNull(Joiner.PRODUCER, (Object)this.fromEntity).put(Joiner.TARGET_SENSOR, this.publishing).put(Joiner.SOURCE_SENSOR, this.transforming).putIfNotNull(Joiner.SEPARATOR, (Object)this.separator).putIfNotNull(Joiner.KEY_VALUE_SEPARATOR, (Object)this.keyValueSeparator).putIfNotNull(Joiner.JOIN_MAP_ENTRIES, (Object)this.joinMapEntries).putIfNotNull(Joiner.QUOTE, (Object)this.quote).putIfNotNull(Joiner.MINIMUM, (Object)this.minimum).putIfNotNull(Joiner.MAXIMUM, (Object)this.maximum).build());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("publishing", this.publishing).add("transforming", this.transforming).add("separator", (Object)this.separator).toString();
        }
    }

    public static abstract class AbstractUpdatingMapBuilder<S, TKey, TVal, B extends AbstractUpdatingMapBuilder<S, TKey, TVal, B>>
    extends AbstractEnricherBuilder<B> {
        protected AttributeSensor<Map<TKey, TVal>> targetSensor;
        protected AttributeSensor<? extends S> fromSensor;
        protected TKey key;
        protected Function<S, ? extends TVal> computing;
        protected Boolean removingIfResultIsNull;

        public AbstractUpdatingMapBuilder(AttributeSensor<Map<TKey, TVal>> target) {
            super(UpdatingMap.class);
            this.targetSensor = target;
        }

        public <S2 extends S> UpdatingMapBuilder<S2, TKey, TVal> from(AttributeSensor<S2> fromSensor) {
            this.fromSensor = (AttributeSensor)Preconditions.checkNotNull(fromSensor);
            return (UpdatingMapBuilder)this;
        }

        public B computing(Function<S, ? extends TVal> val) {
            this.computing = (Function)Preconditions.checkNotNull(val);
            return (B)((AbstractUpdatingMapBuilder)this.self());
        }

        public B key(TKey key) {
            this.key = key;
            return (B)((AbstractUpdatingMapBuilder)this.self());
        }

        public B removingIfResultIsNull(boolean val) {
            this.removingIfResultIsNull = val;
            return (B)((AbstractUpdatingMapBuilder)this.self());
        }

        @Override
        protected String getDefaultUniqueTag() {
            if (this.targetSensor == null || this.fromSensor == null) {
                return null;
            }
            return "updating:" + this.targetSensor.getName() + "<-" + this.fromSensor.getName();
        }

        @Override
        public EnricherSpec<?> build() {
            return (EnricherSpec)super.build().configure((Map)MutableMap.builder().put(UpdatingMap.TARGET_SENSOR, this.targetSensor).put(UpdatingMap.SOURCE_SENSOR, this.fromSensor).putIfNotNull(UpdatingMap.KEY_IN_TARGET_SENSOR, this.key).put(UpdatingMap.COMPUTING, this.computing).putIfNotNull(UpdatingMap.REMOVING_IF_RESULT_IS_NULL, (Object)this.removingIfResultIsNull).build());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("publishing", this.targetSensor).add("fromSensor", this.fromSensor).add("key", this.key).add("computing", this.computing).add("removingIfResultIsNull", (Object)this.removingIfResultIsNull).toString();
        }
    }

    protected static abstract class AbstractPropagatorBuilder<B extends AbstractPropagatorBuilder<B>>
    extends AbstractEnricherBuilder<B> {
        protected final Map<? extends Sensor<?>, ? extends Sensor<?>> propagating;
        protected final Boolean propagatingAll;
        protected final Iterable<? extends Sensor<?>> propagatingAllBut;
        protected Entity fromEntity;
        protected Task<? extends Entity> fromEntitySupplier;

        public AbstractPropagatorBuilder(Map<? extends Sensor<?>, ? extends Sensor<?>> vals) {
            super(Propagator.class);
            Preconditions.checkArgument((((Map)Preconditions.checkNotNull(vals)).size() > 0 ? 1 : 0) != 0, (Object)"propagating-sensors must be non-empty");
            this.propagating = vals;
            this.propagatingAll = null;
            this.propagatingAllBut = null;
        }

        public AbstractPropagatorBuilder(Iterable<? extends Sensor<?>> vals) {
            this(Enrichers.newIdentityMap((Set)ImmutableSet.copyOf(vals)));
        }

        public AbstractPropagatorBuilder(Sensor<?> ... vals) {
            this(Enrichers.newIdentityMap((Set)ImmutableSet.copyOf((Object[])vals)));
        }

        AbstractPropagatorBuilder(boolean propagatingAll, Iterable<? extends Sensor<?>> butVals) {
            super(Propagator.class);
            Preconditions.checkArgument((boolean)propagatingAll, (Object)"Not propagating all; use PropagatingAll(vals)");
            this.propagating = null;
            this.propagatingAll = true;
            this.propagatingAllBut = butVals == null || Iterables.isEmpty(butVals) ? null : butVals;
        }

        public B from(Entity val) {
            this.fromEntity = (Entity)Preconditions.checkNotNull((Object)val);
            return (B)((AbstractPropagatorBuilder)this.self());
        }

        public B from(Task<? extends Entity> val) {
            this.fromEntitySupplier = (Task)Preconditions.checkNotNull(val);
            return (B)((AbstractPropagatorBuilder)this.self());
        }

        @Override
        protected String getDefaultUniqueTag() {
            MutableList summary = MutableList.of();
            if (this.propagating != null) {
                for (Map.Entry<Sensor<?>, Sensor<?>> entry : this.propagating.entrySet()) {
                    if (entry.getKey().getName().equals(entry.getValue().getName())) {
                        summary.add(entry.getKey().getName());
                        continue;
                    }
                    summary.add(entry.getKey().getName() + "->" + entry.getValue().getName());
                }
            }
            if (Boolean.TRUE.equals(this.propagatingAll)) {
                summary.add("ALL");
            }
            if (this.propagatingAllBut != null && !Iterables.isEmpty(this.propagatingAllBut)) {
                MutableList allBut = MutableList.of();
                for (Sensor<?> s : this.propagatingAllBut) {
                    allBut.add(s.getName());
                }
                summary.add("ALL_BUT:" + com.google.common.base.Joiner.on((String)",").join((Iterable)allBut));
            }
            String fromId = this.fromEntity != null ? this.fromEntity.getId() : this.fromEntitySupplier.getId();
            return "propagating[" + fromId + ":" + com.google.common.base.Joiner.on((String)",").join((Iterable)summary) + "]";
        }

        @Override
        public EnricherSpec<? extends Enricher> build() {
            return (EnricherSpec)super.build().configure((Map)MutableMap.builder().putIfNotNull(Propagator.PRODUCER, (Object)this.fromEntity).putIfNotNull(Propagator.PRODUCER, this.fromEntitySupplier).putIfNotNull(Propagator.SENSOR_MAPPING, this.propagating).putIfNotNull(Propagator.PROPAGATING_ALL, (Object)this.propagatingAll).putIfNotNull(Propagator.PROPAGATING_ALL_BUT, this.propagatingAllBut).build());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("fromEntity", (Object)this.fromEntity).add("fromEntitySupplier", this.fromEntitySupplier).add("propagating", this.propagating).add("propagatingAll", (Object)this.propagatingAll).add("propagatingAllBut", this.propagatingAllBut).toString();
        }
    }

    protected static abstract class AbstractTransformerBuilder<S, T, B extends AbstractTransformerBuilder<S, T, B>>
    extends AbstractEnricherBuilder<B> {
        protected final AttributeSensor<S> transforming;
        protected AttributeSensor<T> publishing;
        protected Entity fromEntity;
        protected Function<? super S, ?> computing;
        protected Function<? super SensorEvent<S>, ?> computingFromEvent;

        public AbstractTransformerBuilder(AttributeSensor<S> val) {
            super(Transformer.class);
            this.transforming = (AttributeSensor)Preconditions.checkNotNull(val);
        }

        public <T2 extends T> TransformerBuilder<S, T2> publishing(AttributeSensor<? extends T2> val) {
            this.publishing = (AttributeSensor)Preconditions.checkNotNull(val);
            return (TransformerBuilder)this;
        }

        public B from(Entity val) {
            this.fromEntity = (Entity)Preconditions.checkNotNull((Object)val);
            return (B)((AbstractTransformerBuilder)this.self());
        }

        public B computing(Function<? super S, ? extends T> val) {
            this.computing = (Function)Preconditions.checkNotNull(val);
            return (B)((AbstractTransformerBuilder)this.self());
        }

        public B computingFromEvent(Function<? super SensorEvent<S>, ? extends T> val) {
            this.computingFromEvent = (Function)Preconditions.checkNotNull(val);
            return (B)((AbstractTransformerBuilder)this.self());
        }

        @Override
        protected String getDefaultUniqueTag() {
            if (this.publishing == null) {
                return null;
            }
            return "transformer:" + this.publishing.getName();
        }

        @Override
        public EnricherSpec<?> build() {
            return (EnricherSpec)super.build().configure((Map)MutableMap.builder().putIfNotNull((Object)Transformer.PRODUCER, (Object)this.fromEntity).put((Object)Transformer.TARGET_SENSOR, this.publishing).put((Object)Transformer.SOURCE_SENSOR, this.transforming).putIfNotNull(Transformer.TRANSFORMATION_FROM_VALUE, this.computing).putIfNotNull(Transformer.TRANSFORMATION_FROM_EVENT, this.computingFromEvent).build());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("publishing", this.publishing).add("transforming", this.transforming).add("fromEntity", (Object)this.fromEntity).add("computing", this.computing).toString();
        }
    }

    protected static abstract class AbstractCombinerBuilder<S, T, B extends AbstractCombinerBuilder<S, T, B>>
    extends AbstractEnricherBuilder<B> {
        protected final List<AttributeSensor<? extends S>> combining;
        protected AttributeSensor<T> publishing;
        protected Entity fromEntity;
        protected Function<? super Collection<S>, ? extends T> computing;
        protected Boolean excludingBlank;
        protected Object valueToReportIfNoSensors;
        protected Predicate<Object> valueFilter;
        protected Object defaultValueForUnreportedSensors;

        @SafeVarargs
        public AbstractCombinerBuilder(AttributeSensor<? extends S> ... vals) {
            this((Collection<AttributeSensor<S>>)ImmutableList.copyOf((Object[])vals));
        }

        public AbstractCombinerBuilder(Collection<AttributeSensor<? extends S>> vals) {
            super(Combiner.class);
            Preconditions.checkArgument((((Collection)Preconditions.checkNotNull(vals)).size() > 0 ? 1 : 0) != 0, (Object)"combining-sensors must be non-empty");
            this.combining = ImmutableList.copyOf(vals);
        }

        public <T2 extends T> CombinerBuilder<S, T2> publishing(AttributeSensor<? extends T2> val) {
            this.publishing = (AttributeSensor)Preconditions.checkNotNull(val);
            return (CombinerBuilder)this;
        }

        public B from(Entity val) {
            this.fromEntity = (Entity)Preconditions.checkNotNull((Object)val);
            return (B)((AbstractCombinerBuilder)this.self());
        }

        public B computing(Function<? super Collection<S>, ? extends T> val) {
            this.computing = (Function)Preconditions.checkNotNull(val);
            return (B)((AbstractCombinerBuilder)this.self());
        }

        public B computingSum() {
            Function function = new Function<Collection<S>, Number>(){

                public Number apply(Collection<S> input) {
                    return Enrichers.sum(input, (Number)defaultValueForUnreportedSensors, (Number)valueToReportIfNoSensors, publishing.getTypeToken());
                }
            };
            this.computing(function);
            return (B)((AbstractCombinerBuilder)this.self());
        }

        public B computingAverage() {
            Function function = new Function<Collection<S>, Number>(){

                public Number apply(Collection<S> input) {
                    return Enrichers.average(input, (Number)defaultValueForUnreportedSensors, (Number)valueToReportIfNoSensors, publishing.getTypeToken());
                }
            };
            this.computing(function);
            return (B)((AbstractCombinerBuilder)this.self());
        }

        public B defaultValueForUnreportedSensors(Object val) {
            this.defaultValueForUnreportedSensors = val;
            return (B)((AbstractCombinerBuilder)this.self());
        }

        public B valueToReportIfNoSensors(Object val) {
            this.valueToReportIfNoSensors = val;
            return (B)((AbstractCombinerBuilder)this.self());
        }

        public B excludingBlank() {
            this.excludingBlank = true;
            return (B)((AbstractCombinerBuilder)this.self());
        }

        @Override
        protected String getDefaultUniqueTag() {
            if (this.publishing == null) {
                return null;
            }
            return "combiner:" + this.publishing.getName();
        }

        @Override
        public EnricherSpec<?> build() {
            return (EnricherSpec)super.build().configure((Map)MutableMap.builder().putIfNotNull(Combiner.PRODUCER, (Object)this.fromEntity).put(Combiner.TARGET_SENSOR, this.publishing).put(Combiner.SOURCE_SENSORS, this.combining).putIfNotNull(Combiner.TRANSFORMATION, this.computing).putIfNotNull(Combiner.VALUE_FILTER, this.valueFilter).build());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("combining", this.combining).add("publishing", this.publishing).add("fromEntity", (Object)this.fromEntity).add("computing", this.computing).add("excludingBlank", (Object)this.excludingBlank).add("valueToReportIfNoSensors", this.valueToReportIfNoSensors).add("valueFilter", this.valueFilter).toString();
        }
    }

    protected static abstract class AbstractAggregatorBuilder<S, T, B extends AbstractAggregatorBuilder<S, T, B>>
    extends AbstractEnricherBuilder<B> {
        protected AttributeSensor<S> aggregating;
        protected AttributeSensor<S> keySensor;
        protected AttributeSensor<S> valueSensor;
        protected AttributeSensor<T> publishing;
        protected Entity fromEntity;
        @Deprecated
        protected Function<? super Collection<S>, ? extends T> computing;
        protected Supplier<Function<? super Collection<S>, ? extends T>> computingSupplier = Suppliers.ofInstance(null);
        protected Boolean fromMembers;
        protected Boolean fromChildren;
        protected Boolean excludingBlank;
        protected ImmutableSet<Entity> fromHardcodedProducers;
        protected Predicate<? super Entity> entityFilter;
        protected Predicate<Object> valueFilter;
        protected Object defaultValueForUnreportedSensors;
        protected Object valueToReportIfNoSensors;

        public AbstractAggregatorBuilder(AttributeSensor<S> aggregating) {
            super(Aggregator.class);
            this.aggregating = aggregating;
        }

        public AbstractAggregatorBuilder(AttributeSensor<S> keySensor, AttributeSensor<S> valueSensor) {
            super(MapAggregator.class);
            this.keySensor = keySensor;
            this.valueSensor = valueSensor;
        }

        public <T2 extends T> AggregatorBuilder<S, T2> publishing(AttributeSensor<? extends T2> val) {
            this.publishing = (AttributeSensor)Preconditions.checkNotNull(val);
            return (AggregatorBuilder)this.self();
        }

        public B from(Entity val) {
            this.fromEntity = (Entity)Preconditions.checkNotNull((Object)val);
            return (B)((AbstractAggregatorBuilder)this.self());
        }

        public B fromMembers() {
            this.fromMembers = true;
            return (B)((AbstractAggregatorBuilder)this.self());
        }

        public B fromChildren() {
            this.fromChildren = true;
            return (B)((AbstractAggregatorBuilder)this.self());
        }

        public B fromHardcodedProducers(Iterable<? extends Entity> val) {
            this.fromHardcodedProducers = ImmutableSet.copyOf(val);
            return (B)((AbstractAggregatorBuilder)this.self());
        }

        public B computing(Function<? super Collection<S>, ? extends T> val) {
            this.computingSupplier = Suppliers.ofInstance((Object)Preconditions.checkNotNull(val));
            return (B)((AbstractAggregatorBuilder)this.self());
        }

        private B computingSumLegacy() {
            Function function = new Function<Collection<S>, Number>(){

                public Number apply(Collection<S> input) {
                    return Enrichers.sum(input, (Number)defaultValueForUnreportedSensors, (Number)valueToReportIfNoSensors, publishing.getTypeToken());
                }
            };
            this.computing(function);
            return (B)((AbstractAggregatorBuilder)this.self());
        }

        private B computingAverageLegacy() {
            Function function = new Function<Collection<S>, Number>(){

                public Number apply(Collection<S> input) {
                    return Enrichers.average(input, (Number)defaultValueForUnreportedSensors, (Number)valueToReportIfNoSensors, publishing.getTypeToken());
                }
            };
            this.computing(function);
            return (B)((AbstractAggregatorBuilder)this.self());
        }

        public B computingSum() {
            this.computingSupplier = new Supplier<Function<? super Collection<S>, ? extends T>>(){

                public Function<? super Collection<S>, ? extends T> get() {
                    return new ComputingSum((Number)defaultValueForUnreportedSensors, (Number)valueToReportIfNoSensors, publishing.getTypeToken());
                }
            };
            return (B)((AbstractAggregatorBuilder)this.self());
        }

        public B computingAverage() {
            this.computingSupplier = new Supplier<Function<? super Collection<S>, ? extends T>>(){

                public Function<? super Collection<S>, ? extends T> get() {
                    return new ComputingAverage((Number)defaultValueForUnreportedSensors, (Number)valueToReportIfNoSensors, publishing.getTypeToken());
                }
            };
            return (B)((AbstractAggregatorBuilder)this.self());
        }

        public B defaultValueForUnreportedSensors(S val) {
            this.defaultValueForUnreportedSensors = val;
            return (B)((AbstractAggregatorBuilder)this.self());
        }

        public B valueToReportIfNoSensors(Object val) {
            this.valueToReportIfNoSensors = val;
            return (B)((AbstractAggregatorBuilder)this.self());
        }

        public B entityFilter(Predicate<? super Entity> val) {
            this.entityFilter = val;
            return (B)((AbstractAggregatorBuilder)this.self());
        }

        public B valueFilter(Predicate<Object> val) {
            this.valueFilter = val;
            return (B)((AbstractAggregatorBuilder)this.self());
        }

        public B excludingBlank() {
            this.excludingBlank = true;
            return (B)((AbstractAggregatorBuilder)this.self());
        }

        @Override
        protected String getDefaultUniqueTag() {
            if (this.publishing == null) {
                return null;
            }
            return "aggregator:" + this.publishing.getName();
        }

        @Override
        public EnricherSpec<?> build() {
            return (EnricherSpec)super.build().configure((Map)MutableMap.builder().putIfNotNull((Object)Aggregator.PRODUCER, (Object)this.fromEntity).put((Object)Aggregator.TARGET_SENSOR, this.publishing).putIfNotNull(Aggregator.SOURCE_SENSOR, this.aggregating).putIfNotNull(MapAggregator.KEY_SENSOR, this.keySensor).putIfNotNull(MapAggregator.VALUE_SENSOR, this.valueSensor).putIfNotNull((Object)Aggregator.FROM_CHILDREN, (Object)this.fromChildren).putIfNotNull((Object)Aggregator.FROM_MEMBERS, (Object)this.fromMembers).putIfNotNull(Aggregator.TRANSFORMATION, this.computingSupplier.get()).putIfNotNull((Object)Aggregator.FROM_HARDCODED_PRODUCERS, this.fromHardcodedProducers).putIfNotNull((Object)Aggregator.EXCLUDE_BLANK, (Object)this.excludingBlank).putIfNotNull((Object)Aggregator.ENTITY_FILTER, this.entityFilter).putIfNotNull((Object)Aggregator.VALUE_FILTER, this.valueFilter).putIfNotNull((Object)Aggregator.DEFAULT_MEMBER_VALUE, this.defaultValueForUnreportedSensors).build());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("aggregating", this.aggregating).add("keySensor", this.keySensor).add("valueSensor", this.valueSensor).add("publishing", this.publishing).add("fromEntity", (Object)this.fromEntity).add("computing", this.computingSupplier.get()).add("fromMembers", (Object)this.fromMembers).add("fromChildren", (Object)this.fromChildren).add("excludingBlank", (Object)this.excludingBlank).add("fromHardcodedProducers", this.fromHardcodedProducers).add("entityFilter", this.entityFilter).add("valueFilter", this.valueFilter).add("defaultValueForUnreportedSensors", this.defaultValueForUnreportedSensors).add("valueToReportIfNoSensors", this.valueToReportIfNoSensors).toString();
        }
    }

    protected static abstract class AbstractInitialBuilder<B extends AbstractInitialBuilder<B>>
    extends Builder<B> {
        protected AbstractInitialBuilder() {
        }

        public PropagatorBuilder propagating(Map<? extends Sensor<?>, ? extends Sensor<?>> vals) {
            return new PropagatorBuilder(vals);
        }

        public PropagatorBuilder propagating(Iterable<? extends Sensor<?>> vals) {
            return new PropagatorBuilder(vals);
        }

        public PropagatorBuilder propagating(Sensor<?> ... vals) {
            return new PropagatorBuilder(vals);
        }

        public PropagatorBuilder propagatingAll() {
            return new PropagatorBuilder(true, null);
        }

        public PropagatorBuilder propagatingAllButUsualAnd(Sensor<?> ... vals) {
            return new PropagatorBuilder(true, (Iterable<? extends Sensor<?>>)ImmutableSet.builder().addAll(Propagator.SENSORS_NOT_USUALLY_PROPAGATED).add((Object[])vals).build());
        }

        public PropagatorBuilder propagatingAllBut(Sensor<?> ... vals) {
            return new PropagatorBuilder(true, (Iterable<? extends Sensor<?>>)ImmutableSet.copyOf((Object[])vals));
        }

        public PropagatorBuilder propagatingAllBut(Iterable<? extends Sensor<?>> vals) {
            return new PropagatorBuilder(true, vals);
        }

        public <S> TransformerBuilder<S, Object> transforming(AttributeSensor<S> val) {
            return new TransformerBuilder(val);
        }

        public <S> CombinerBuilder<S, Object> combining(Collection<AttributeSensor<? extends S>> vals) {
            return new CombinerBuilder(vals);
        }

        @SafeVarargs
        public final <S> CombinerBuilder<S, Object> combining(AttributeSensor<? extends S> ... vals) {
            return new CombinerBuilder(vals);
        }

        public <S> AggregatorBuilder<S, Object> aggregating(AttributeSensor<S> val) {
            return new AggregatorBuilder(val);
        }

        public <S> AggregatorBuilder<S, Object> aggregating(AttributeSensor<S> keySensor, AttributeSensor<S> valueSensor) {
            return new AggregatorBuilder(keySensor, valueSensor);
        }

        public <S, TKey, TVal> UpdatingMapBuilder<S, TKey, TVal> updatingMap(AttributeSensor<Map<TKey, TVal>> target) {
            return new UpdatingMapBuilder(target);
        }

        public JoinerBuilder joining(AttributeSensor<?> source) {
            return new JoinerBuilder(source);
        }

        public ReducerBuilder reducing(Class<? extends Reducer> clazz, List<AttributeSensor<?>> sourceSensors) {
            return new ReducerBuilder(clazz, sourceSensors);
        }
    }

    public static abstract class AbstractEnricherBuilder<B extends AbstractEnricherBuilder<B>>
    extends Builder<B> {
        final Class<? extends Enricher> enricherType;
        Boolean suppressDuplicates;
        String uniqueTag;
        Set<Object> tags = MutableSet.of();

        public AbstractEnricherBuilder(Class<? extends Enricher> enricherType) {
            this.enricherType = enricherType;
        }

        public B uniqueTag(String tag) {
            this.uniqueTag = (String)Preconditions.checkNotNull((Object)tag);
            return (B)((AbstractEnricherBuilder)this.self());
        }

        public B addTag(Object tag) {
            this.tags.add(Preconditions.checkNotNull((Object)tag));
            return (B)((AbstractEnricherBuilder)this.self());
        }

        public B suppressDuplicates(Boolean suppressDuplicates) {
            this.suppressDuplicates = suppressDuplicates;
            return (B)((AbstractEnricherBuilder)this.self());
        }

        protected abstract String getDefaultUniqueTag();

        protected EnricherSpec<? extends Enricher> build() {
            EnricherSpec spec = EnricherSpec.create(this.enricherType);
            String uniqueTag2 = this.uniqueTag;
            if (uniqueTag2 == null) {
                uniqueTag2 = this.getDefaultUniqueTag();
            }
            if (uniqueTag2 != null) {
                spec.uniqueTag(uniqueTag2);
            }
            if (!this.tags.isEmpty()) {
                spec.tags(this.tags);
            }
            if (this.suppressDuplicates != null) {
                spec.configure(AbstractEnricher.SUPPRESS_DUPLICATES, (Object)this.suppressDuplicates);
            }
            return spec;
        }
    }

    public static abstract class Builder<B extends Builder<B>> {
        protected B self() {
            return (B)this;
        }
    }
}

