/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.ha;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.osgi.framework.Bundle;

@Beta
public class OsgiBundleInstallationResult {
    String message;
    ManagedBundle metadata;
    Bundle bundle;
    ResultCode code;
    Runnable deferredStart;
    final List<RegisteredType> typesInstalled = MutableList.of();
    @Deprecated
    private final List<String> catalogItemsInstalled = MutableList.of();

    public String getMessage() {
        return this.message;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public ManagedBundle getMetadata() {
        return this.metadata;
    }

    public ResultCode getCode() {
        return this.code;
    }

    public List<RegisteredType> getTypesInstalled() {
        return this.typesInstalled;
    }

    @Deprecated
    public List<String> getCatalogItemsInstalled() {
        return ImmutableList.copyOf(this.catalogItemsInstalled);
    }

    public VersionedName getVersionedName() {
        if (this.getMetadata() == null) {
            return null;
        }
        return this.getMetadata().getVersionedName();
    }

    public Runnable getDeferredStart() {
        return this.deferredStart;
    }

    void setIgnoringAlreadyInstalled() {
        this.code = ResultCode.IGNORING_BUNDLE_AREADY_INSTALLED;
        this.message = "Bundle " + this.getMetadata().getVersionedName() + " already installed as " + this.getMetadata().getId();
    }

    void setIgnoringForciblyRemoved(VersionedName requestedBundle, Maybe<VersionedName> replacementBundle) {
        this.code = ResultCode.IGNORING_BUNDLE_FORCIBLY_REMOVED;
        this.message = "Bundle " + requestedBundle + " forcibly removed, " + (replacementBundle.isPresentAndNonNull() ? "upgraded to " + ((VersionedName)replacementBundle.get()).getOsgiVersionString() : "no upgrade defined");
    }

    public String toString() {
        return OsgiBundleInstallationResult.class.getSimpleName() + "[" + (Object)((Object)this.code) + ", " + this.metadata + ", " + this.message + "]";
    }

    public void addType(RegisteredType ci) {
        this.typesInstalled.add(ci);
        this.catalogItemsInstalled.add(ci.getId());
    }

    public static enum ResultCode {
        INSTALLED_NEW_BUNDLE(false),
        UPDATED_EXISTING_BUNDLE(false),
        IGNORING_BUNDLE_AREADY_INSTALLED(false),
        IGNORING_BUNDLE_FORCIBLY_REMOVED(false),
        ERROR_PREPARING_BUNDLE(true),
        ERROR_LAUNCHING_BUNDLE(true),
        BUNDLE_REMOVED(false),
        ERROR_REMOVING_BUNDLE_IN_USE(true),
        ERROR_REMOVING_BUNDLE_OTHER(true);

        final boolean isError;

        private ResultCode(boolean isError) {
            this.isError = isError;
        }

        public boolean isError() {
            return this.isError;
        }
    }
}

