/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.SubscriptionContext;
import org.apache.brooklyn.api.mgmt.SubscriptionHandle;
import org.apache.brooklyn.api.mgmt.rebind.RebindSupport;
import org.apache.brooklyn.api.mgmt.rebind.mementos.LocationMemento;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.Configurable;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigConstraints;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.internal.AbstractConfigMapImpl;
import org.apache.brooklyn.core.entity.internal.ConfigUtilsInternal;
import org.apache.brooklyn.core.internal.storage.BrooklynStorage;
import org.apache.brooklyn.core.internal.storage.Reference;
import org.apache.brooklyn.core.internal.storage.impl.BasicReference;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.location.geo.HasHostGeoInfo;
import org.apache.brooklyn.core.location.geo.HostGeoInfo;
import org.apache.brooklyn.core.location.internal.LocationConfigMap;
import org.apache.brooklyn.core.location.internal.LocationDynamicType;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.core.mgmt.internal.LocalLocationManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.internal.SubscriptionTracker;
import org.apache.brooklyn.core.mgmt.rebind.BasicLocationRebindSupport;
import org.apache.brooklyn.core.objs.AbstractBrooklynObject;
import org.apache.brooklyn.core.objs.AbstractConfigurationSupportInternal;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.FlagUtils;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.stream.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLocation
extends AbstractBrooklynObject
implements LocationInternal,
HasHostGeoInfo,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLocation.class);
    public static final ConfigKey<Location> PARENT_LOCATION = new BasicConfigKey<Location>(Location.class, "parentLocation");
    public static final ConfigKey<Boolean> TEMPORARY_LOCATION = ConfigKeys.newBooleanConfigKey("temporaryLocation", "Indicates that the location is a temporary location that has been created to test connectivity, and thatthe location's events should not be recorded by usage listeners", false);
    private final AtomicBoolean configured = new AtomicBoolean();
    private Reference<Long> creationTimeUtc = new BasicReference<Long>(System.currentTimeMillis());
    private Reference<Location> parent = new BasicReference<Location>();
    private Set<Location> children = Sets.newLinkedHashSet();
    private Reference<String> name = new BasicReference<String>();
    private boolean displayNameAutoGenerated = true;
    private Reference<HostGeoInfo> hostGeoInfo = new BasicReference<HostGeoInfo>();
    private BasicConfigurationSupport config = new BasicConfigurationSupport();
    private BasicSubscriptionSupport subscriptions = new BasicSubscriptionSupport();
    private LocationConfigMap configMap = new LocationConfigMap(this);
    protected transient SubscriptionTracker _subscriptionTracker;
    private volatile boolean managed;
    private boolean inConstruction = true;
    private Reference<Map<Class<?>, Object>> extensions = new BasicReference<ConcurrentMap>(Maps.newConcurrentMap());
    private final LocationDynamicType locationType = new LocationDynamicType(this);

    public AbstractLocation() {
        this(Maps.newLinkedHashMap());
    }

    public AbstractLocation(Map<?, ?> properties) {
        super(properties);
        if (this.isLegacyConstruction()) {
            boolean deferConstructionChecks;
            BrooklynObjectInternal checkWeGetThis = this.configure((Map)properties);
            assert (this.equals(checkWeGetThis)) : this + " configure method does not return itself; returns " + checkWeGetThis + " instead of " + this;
            boolean bl = deferConstructionChecks = properties.containsKey("deferConstructionChecks") && TypeCoercions.coerce(properties.get("deferConstructionChecks"), Boolean.class) != false;
            if (!deferConstructionChecks) {
                FlagUtils.checkRequiredFields(this);
            }
        }
        this.inConstruction = false;
    }

    protected void assertNotYetManaged() {
        if (!this.inConstruction && Locations.isManaged(this)) {
            LOG.warn("Configuration being made to {} after deployment; may not be supported in future versions", (Object)this);
        }
    }

    @Override
    public void setManagementContext(ManagementContextInternal managementContext) {
        super.setManagementContext(managementContext);
        if (this.displayNameAutoGenerated && this.getId() != null) {
            this.name.set(this.getClass().getSimpleName() + ":" + this.getId().substring(0, Math.min(this.getId().length(), 4)));
        }
    }

    @Override
    @Deprecated
    public AbstractLocation configure(Map<?, ?> properties) {
        this.assertNotYetManaged();
        boolean firstTime = !this.configured.getAndSet(true);
        this.config().putAll(properties);
        if (properties.containsKey(PARENT_LOCATION.getName())) {
            this.setParent((Location)this.config().get(PARENT_LOCATION));
            this.config().removeKey(PARENT_LOCATION);
        }
        properties = ConfigUtilsInternal.setAllConfigKeys(properties, this.getLocationTypeInternal().getConfigKeys().values(), this);
        ConfigBag configBag = ConfigBag.newInstance(properties);
        FlagUtils.setFieldsFromFlagsWithBag(this, properties, configBag, firstTime);
        FlagUtils.setAllConfigKeys(this, configBag, false);
        if (properties.containsKey("displayName")) {
            this.name.set((String)AbstractLocation.removeIfPossible(properties, "displayName"));
            this.displayNameAutoGenerated = false;
        } else if (properties.containsKey("name")) {
            this.name.set((String)AbstractLocation.removeIfPossible(properties, "name"));
            this.displayNameAutoGenerated = false;
        } else if (this.isLegacyConstruction()) {
            this.name.set(this.getClass().getSimpleName() + ":" + this.getId().substring(0, Math.min(this.getId().length(), 4)));
            this.displayNameAutoGenerated = true;
        }
        if (JavaGroovyEquivalents.groovyTruth(properties.get("iso3166"))) {
            Object rawCodes = AbstractLocation.removeIfPossible(properties, "iso3166");
            Object codes = rawCodes instanceof CharSequence ? ImmutableSet.copyOf((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)rawCodes)) : TypeCoercions.coerce(rawCodes, new TypeToken<Set<String>>(){});
            this.config().set(LocationConfigKeys.ISO_3166, codes);
        }
        return this;
    }

    private static Object removeIfPossible(Map<?, ?> map, Object key) {
        try {
            return map.remove(key);
        }
        catch (Exception e) {
            return map.get(key);
        }
    }

    public boolean isManaged() {
        return this.getManagementContext() != null && this.managed;
    }

    public void onManagementStarted() {
        if (this.displayNameAutoGenerated) {
            this.name.set(this.getClass().getSimpleName() + ":" + this.getId().substring(0, Math.min(this.getId().length(), 4)));
        }
        this.managed = true;
    }

    public void onManagementStopped() {
        this.managed = false;
        if (this.getManagementContext().isRunning()) {
            BrooklynStorage storage = ((ManagementContextInternal)this.getManagementContext()).getStorage();
            storage.remove(this.getId() + "-parent");
            storage.remove(this.getId() + "-children");
            storage.remove(this.getId() + "-creationTime");
            storage.remove(this.getId() + "-hostGeoInfo");
            storage.remove(this.getId() + "-displayName");
            storage.remove(this.getId() + "-config");
        }
    }

    public String getDisplayName() {
        return this.name.get();
    }

    protected boolean isDisplayNameAutoGenerated() {
        return this.displayNameAutoGenerated;
    }

    public Location getParent() {
        return this.parent.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Location> getChildren() {
        Set<Location> set = this.children;
        synchronized (set) {
            return ImmutableList.copyOf(this.children);
        }
    }

    public void setParent(Location newParent) {
        this.setParent(newParent, true);
    }

    public void setParent(Location newParent, boolean updateChildListParents) {
        if (newParent == this) {
            throw new IllegalArgumentException("Location cannot be its own parent: " + this);
        }
        if (newParent == this.parent.get()) {
            return;
        }
        if (this.parent.get() != null) {
            Location oldParent = this.parent.get();
            this.parent.set(null);
            if (updateChildListParents) {
                ((AbstractLocation)oldParent).removeChild(this);
            }
        }
        this.parent.set(newParent);
        if (newParent != null && updateChildListParents) {
            ((AbstractLocation)newParent).addChild(this);
        }
        this.onChanged();
    }

    @Override
    public BrooklynObjectInternal.ConfigurationSupportInternal config() {
        return this.config;
    }

    @Override
    @Beta
    public BasicSubscriptionSupport subscriptions() {
        return this.subscriptions;
    }

    public <T> T getConfig(ConfigKey.HasConfigKey<T> key) {
        return (T)this.config().get(key);
    }

    public <T> T getConfig(ConfigKey<T> key) {
        return (T)this.config().get(key);
    }

    @Override
    public void setDisplayName(String newName) {
        this.name.set(newName);
        this.displayNameAutoGenerated = false;
        this.onChanged();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Location)) {
            return false;
        }
        Location l = (Location)o;
        return this.getId().equals(l.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean containsLocation(Location potentialDescendent) {
        for (Location loc = potentialDescendent; loc != null; loc = loc.getParent()) {
            if (this != loc) continue;
            return true;
        }
        return false;
    }

    protected <T extends Location> T addChild(LocationSpec<T> spec) {
        Location child = this.getManagementContext().getLocationManager().createLocation(spec);
        this.addChild(child);
        return (T)child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(Location child) {
        Set<Location> set = this.children;
        synchronized (set) {
            for (Location contender : this.children) {
                if (contender != child) continue;
                return;
            }
            this.children.add(child);
        }
        if (this.isManaged()) {
            if (!this.getManagementContext().getLocationManager().isManaged(child)) {
                Locations.manage(child, this.getManagementContext());
            }
        } else if (this.getManagementContext() != null && ((LocalLocationManager)this.getManagementContext().getLocationManager()).getLocationEvenIfPreManaged(child.getId()) == null) {
            ((ManagementContextInternal)this.getManagementContext()).prePreManage(child);
        }
        this.children.add(child);
        child.setParent((Location)this);
        this.onChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChild(Location child) {
        boolean removed;
        Set<Location> set = this.children;
        synchronized (set) {
            removed = this.children.remove(child);
        }
        if (removed) {
            if (child instanceof Closeable) {
                Streams.closeQuietly((Closeable)((Closeable)child));
            }
            child.setParent(null);
            if (this.isManaged() && Locations.isManaged(child)) {
                this.getManagementContext().getLocationManager().unmanage(child);
            }
        }
        this.onChanged();
        return removed;
    }

    @Override
    public void init() {
        super.init();
        this.loadExtension();
    }

    @Override
    public void rebind() {
        super.rebind();
        this.loadExtension();
    }

    private void loadExtension() {
        Map extensions = (Map)((Object)this.getConfig(LocationConfigKeys.EXTENSIONS));
        if (extensions != null) {
            for (Map.Entry extension : extensions.entrySet()) {
                try {
                    Class<?> extensionClassType = new ClassLoaderUtils((Object)this, this.getManagementContext()).loadClass((String)extension.getKey());
                    if (this.hasExtension(extensionClassType)) continue;
                    Object extensionClass = new ClassLoaderUtils((Object)this, this.getManagementContext()).loadClass((String)extension.getValue()).newInstance();
                    this.addExtension(extensionClassType, extensionClass);
                }
                catch (Exception e) {
                    LOG.error("Location extension can not be loaded (rethrowing): {} {} {}", new Object[]{extension.getKey(), extension.getValue(), e});
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }
    }

    protected void onChanged() {
        if (this.isManaged()) {
            this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)this);
        }
    }

    public String toString() {
        return this.string().toString();
    }

    public String toVerboseString() {
        return this.toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this.getClass()).add("id", (Object)this.getId()).add("name", this.name);
    }

    @Override
    public HostGeoInfo getHostGeoInfo() {
        return this.hostGeoInfo.get();
    }

    public void setHostGeoInfo(HostGeoInfo hostGeoInfo) {
        if (hostGeoInfo != null) {
            this.hostGeoInfo.set(hostGeoInfo);
            this.config().set(LocationConfigKeys.LATITUDE, hostGeoInfo.latitude);
            this.config().set(LocationConfigKeys.LONGITUDE, hostGeoInfo.longitude);
        }
    }

    @Override
    public RebindSupport<LocationMemento> getRebindSupport() {
        return new BasicLocationRebindSupport(this);
    }

    public LocationDynamicType getLocationTypeInternal() {
        return this.locationType;
    }

    @Override
    public BrooklynObjectInternal.RelationSupportInternal<Location> relations() {
        return super.relations();
    }

    public boolean hasExtension(Class<?> extensionType) {
        return this.extensions.get().containsKey(Preconditions.checkNotNull(extensionType, (Object)"extensionType"));
    }

    public <T> T getExtension(Class<T> extensionType) {
        Object extension = this.extensions.get().get(Preconditions.checkNotNull(extensionType, (Object)"extensionType"));
        if (extension == null) {
            throw new IllegalArgumentException("No extension of type " + extensionType + " registered for location " + this);
        }
        return (T)extension;
    }

    @Override
    public <T> void addExtension(Class<T> extensionType, T extension) {
        Preconditions.checkNotNull(extensionType, (Object)"extensionType");
        Preconditions.checkNotNull(extension, (Object)"extension");
        Preconditions.checkArgument((boolean)extensionType.isInstance(extension), (String)"extension %s does not implement %s", (Object[])new Object[]{extension, extensionType});
        this.extensions.get().put(extensionType, extension);
    }

    @Override
    public Map<String, String> toMetadataRecord() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.getDisplayName() != null) {
            builder.put((Object)"displayName", (Object)this.getDisplayName());
        }
        if (this.getParent() != null && this.getParent().getDisplayName() != null) {
            builder.put((Object)"parentDisplayName", (Object)this.getParent().getDisplayName());
        }
        return builder.build();
    }

    public class BasicSubscriptionSupport
    implements BrooklynObjectInternal.SubscriptionSupportInternal {
        public <T> SubscriptionHandle subscribe(Entity producer, Sensor<T> sensor, SensorEventListener<? super T> listener) {
            return this.getSubscriptionTracker().subscribe(producer, sensor, listener);
        }

        public <T> SubscriptionHandle subscribe(Map<String, ?> flags, Entity producer, Sensor<T> sensor, SensorEventListener<? super T> listener) {
            return this.getSubscriptionTracker().subscribe(flags, producer, sensor, listener);
        }

        public <T> SubscriptionHandle subscribeToMembers(Group producerGroup, Sensor<T> sensor, SensorEventListener<? super T> listener) {
            return this.getSubscriptionTracker().subscribeToMembers(producerGroup, sensor, listener);
        }

        public <T> SubscriptionHandle subscribeToChildren(Entity producerParent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
            return this.getSubscriptionTracker().subscribeToChildren(producerParent, sensor, listener);
        }

        public boolean unsubscribe(Entity producer) {
            return this.getSubscriptionTracker().unsubscribe(producer);
        }

        public boolean unsubscribe(Entity producer, SubscriptionHandle handle) {
            return this.getSubscriptionTracker().unsubscribe(producer, handle);
        }

        public boolean unsubscribe(SubscriptionHandle handle) {
            return this.getSubscriptionTracker().unsubscribe(handle);
        }

        @Override
        public void unsubscribeAll() {
            this.getSubscriptionTracker().unsubscribeAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SubscriptionTracker getSubscriptionTracker() {
            AbstractLocation abstractLocation = AbstractLocation.this;
            synchronized (abstractLocation) {
                if (AbstractLocation.this._subscriptionTracker != null) {
                    return AbstractLocation.this._subscriptionTracker;
                }
                AbstractLocation.this._subscriptionTracker = new SubscriptionTracker(this.newSubscriptionContext());
                return AbstractLocation.this._subscriptionTracker;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SubscriptionContext newSubscriptionContext() {
            AbstractLocation abstractLocation = AbstractLocation.this;
            synchronized (abstractLocation) {
                return AbstractLocation.this.getManagementContext().getSubscriptionContext((Location)AbstractLocation.this);
            }
        }
    }

    private class BasicConfigurationSupport
    extends AbstractConfigurationSupportInternal {
        private BasicConfigurationSupport() {
        }

        @Override
        protected <T> void assertValid(ConfigKey<T> key, T val) {
            ConfigConstraints.assertValid(AbstractLocation.this, key, val);
        }

        @Override
        protected <T> void onConfigChanging(ConfigKey<T> key, Object val) {
        }

        @Override
        protected <T> void onConfigChanged(ConfigKey<T> key, Object val) {
            AbstractLocation.this.onChanged();
        }

        @Override
        public void refreshInheritedConfig() {
        }

        @Override
        public void refreshInheritedConfigOfChildren() {
        }

        @Override
        protected ExecutionContext getContext() {
            return AbstractLocation.this.getManagementContext().getServerExecutionContext();
        }

        protected AbstractConfigMapImpl<Location> getConfigsInternal() {
            return AbstractLocation.this.configMap;
        }

        @Override
        protected BrooklynObject getContainer() {
            return AbstractLocation.this;
        }
    }
}

