/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.jclouds.cloudstack.domain.Snapshot;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class ListSnapshotsOptions
extends AccountInDomainOptions {
    public static final ListSnapshotsOptions NONE = new ListSnapshotsOptions();

    public ListSnapshotsOptions id(String id) {
        this.queryParameters.replaceValues((Object)"id", (Iterable)ImmutableSet.of((Object)(id + "")));
        return this;
    }

    public ListSnapshotsOptions interval(Snapshot.Interval interval) {
        this.queryParameters.replaceValues((Object)"intervaltype", (Iterable)ImmutableSet.of((Object)((Object)((Object)interval) + "")));
        return this;
    }

    public ListSnapshotsOptions isRecursive(boolean isRecursive) {
        this.queryParameters.replaceValues((Object)"isrecursive", (Iterable)ImmutableSet.of((Object)(isRecursive + "")));
        return this;
    }

    public ListSnapshotsOptions keyword(String keyword) {
        this.queryParameters.replaceValues((Object)"keyword", (Iterable)ImmutableSet.of((Object)(keyword + "")));
        return this;
    }

    public ListSnapshotsOptions name(String name) {
        this.queryParameters.replaceValues((Object)"name", (Iterable)ImmutableSet.of((Object)(name + "")));
        return this;
    }

    public ListSnapshotsOptions snapshotType(Snapshot.Type snapshotType) {
        this.queryParameters.replaceValues((Object)"snapshottype", (Iterable)ImmutableSet.of((Object)((Object)((Object)snapshotType) + "")));
        return this;
    }

    public ListSnapshotsOptions volumeId(String volumeId) {
        this.queryParameters.replaceValues((Object)"volumeid", (Iterable)ImmutableSet.of((Object)(volumeId + "")));
        return this;
    }

    public ListSnapshotsOptions projectId(String projectId) {
        this.queryParameters.replaceValues((Object)"projectid", (Iterable)ImmutableSet.of((Object)(projectId + "")));
        return this;
    }

    public ListSnapshotsOptions tags(Map<String, String> tags) {
        int count = 0;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.queryParameters.replaceValues((Object)String.format("tags[%d].key", count), (Iterable)ImmutableSet.of((Object)entry.getKey()));
            this.queryParameters.replaceValues((Object)String.format("tags[%d].value", count), (Iterable)ImmutableSet.of((Object)entry.getValue()));
            ++count;
        }
        return this;
    }

    public static class Builder {
        public static ListSnapshotsOptions accountInDomain(String account, String domainId) {
            return (ListSnapshotsOptions)new ListSnapshotsOptions().accountInDomain(account, domainId);
        }

        public static ListSnapshotsOptions domainId(String domainId) {
            return (ListSnapshotsOptions)new ListSnapshotsOptions().domainId(domainId);
        }

        public static ListSnapshotsOptions id(String id) {
            return new ListSnapshotsOptions().id(id);
        }

        public static ListSnapshotsOptions interval(Snapshot.Interval interval) {
            return new ListSnapshotsOptions().interval(interval);
        }

        public static ListSnapshotsOptions isRecursive(boolean isRecursive) {
            return new ListSnapshotsOptions().isRecursive(isRecursive);
        }

        public static ListSnapshotsOptions keyword(String keyword) {
            return new ListSnapshotsOptions().keyword(keyword);
        }

        public static ListSnapshotsOptions name(String name) {
            return new ListSnapshotsOptions().name(name);
        }

        public static ListSnapshotsOptions snapshotType(Snapshot.Type snapshotType) {
            return new ListSnapshotsOptions().snapshotType(snapshotType);
        }

        public static ListSnapshotsOptions volumeId(String volumeId) {
            return new ListSnapshotsOptions().volumeId(volumeId);
        }

        public static ListSnapshotsOptions projectId(String projectId) {
            return new ListSnapshotsOptions().projectId(projectId);
        }

        public static ListSnapshotsOptions tags(Map<String, String> tags) {
            return new ListSnapshotsOptions().tags(tags);
        }
    }
}

