/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.mongodb;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.OsDetails;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.entity.nosql.mongodb.AbstractMongoDBServer;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBAuthenticationUtils;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBClientSupport;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBServer;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBServerImpl;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.software.base.lifecycle.NaiveScriptRunner;
import org.apache.brooklyn.entity.software.base.lifecycle.ScriptHelper;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMongoDBSshDriver
extends AbstractSoftwareProcessSshDriver {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMongoDBSshDriver.class);

    public AbstractMongoDBSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    public String getArchiveNameFormat() {
        return this.getOsTag() + "-%s";
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        LinkedList<String> commands = new LinkedList<String>();
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs));
        commands.add(BashCommands.INSTALL_TAR);
        commands.add("tar xzfv " + saveAs);
        this.newScript((String)"installing").failOnNonZeroResultCode().body.append(commands).execute();
    }

    public void customize() {
        ImmutableMap ports = ImmutableMap.of((Object)"port", (Object)this.getServerPort());
        Networking.checkPortsValid((Map)ports);
        LinkedList<String> commands = new LinkedList<String>();
        commands.add(String.format("mkdir -p %s", this.getDataDirectory()));
        if (MongoDBAuthenticationUtils.usesAuthentication((Entity)this.entity)) {
            String destinationLocation = Os.mergePaths((String[])new String[]{this.getRunDir(), "mongodb-keyfile"});
            this.entity.sensors().set(AbstractMongoDBServer.MONGODB_KEYFILE_DESTINATION, (Object)destinationLocation);
            String keyfileContents = (String)this.entity.config().get(AbstractMongoDBServer.MONGODB_KEYFILE_CONTENTS);
            if (Strings.isNullOrEmpty((String)keyfileContents)) {
                String keyfileUrl = (String)this.entity.config().get(AbstractMongoDBServer.MONGODB_KEYFILE_URL);
                if (Strings.isNullOrEmpty((String)keyfileUrl)) {
                    throw new IllegalStateException("MongoDBAuthenticationUtils.usesAuthentication returned true, but neither keyfileContents nor keyfileUrl are set");
                }
                this.copyResource(keyfileUrl, destinationLocation);
            } else {
                commands.add(BashCommands.pipeTextToFile((String)keyfileContents, (String)destinationLocation));
            }
            commands.add("chmod 600 " + destinationLocation);
        }
        this.newScript((String)"customizing").updateTaskAndFailOnNonZeroResultCode().body.append(commands).execute();
        String templateUrl = (String)this.entity.getConfig(MongoDBServer.MONGODB_CONF_TEMPLATE_URL);
        if (!Strings.isNullOrEmpty((String)templateUrl)) {
            this.copyTemplate(templateUrl, this.getConfFile());
        }
        if (MongoDBAuthenticationUtils.usesAuthentication((Entity)this.entity)) {
            this.launch((ImmutableList.Builder<String>)this.getArgsBuilderWithNoAuthentication((AbstractMongoDBServer)this.getEntity()).add((Object[])new String[]{"--dbpath", this.getDataDirectory()}));
            this.newScript((String)"create-user").body.append((CharSequence)String.format("%s --port %s --host localhost admin --eval \"db.createUser({user: '%s',pwd: '%s',roles: [ 'root' ]})\"", Os.mergePaths((String[])new String[]{this.getExpandedInstallDir(), "bin/mongo"}), this.getServerPort(), this.getRootUsername(), MongoDBAuthenticationUtils.getRootPassword((Entity)this.entity))).updateTaskAndFailOnNonZeroResultCode().execute();
            this.stop();
        }
    }

    public boolean isRunning() {
        try {
            if (this.entity instanceof MongoDBServerImpl && !((MongoDBServerImpl)this.entity).clientAccessEnabled()) {
                return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "check-running").execute() == 0;
            }
            return MongoDBClientSupport.forServer((AbstractMongoDBServer)this.entity).ping();
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            return false;
        }
    }

    public void stop() {
        new ScriptHelper((NaiveScriptRunner)this, (String)"Send SIGINT to MongoDB server").body.append((CharSequence)new StringBuilder().append((String)"MONGO_PID=$(cat ").append((String)this.getPidFile()).append((String)")\n").toString()).body.append((CharSequence)"kill -2 $MONGO_PID\n").body.append((CharSequence)"for i in {1..10}\ndo\n    kill -0 $MONGO_PID || exit \n    sleep 1\ndone\necho \"mongoDB process still running after 10 seconds; continuing but may subsequently fail\"").execute();
    }

    public String getOsDir() {
        return this.getLocation().getOsDetails().isMac() ? "osx" : "linux";
    }

    public String getOsTag() {
        OsDetails os = this.getLocation().getOsDetails();
        if (os == null) {
            return "mongodb-linux-x86_64";
        }
        if (os.isMac()) {
            return "mongodb-osx-x86_64";
        }
        String arch = os.is64bit() ? "x86_64" : "i686";
        return "mongodb-linux-" + arch;
    }

    public String getDataDirectory() {
        String result = (String)this.entity.getConfig(MongoDBServer.DATA_DIRECTORY);
        if (result != null) {
            return result;
        }
        return this.getRunDir() + "/data";
    }

    protected String getLogFile() {
        return this.getRunDir() + "/log.txt";
    }

    protected String getPidFile() {
        return this.getRunDir() + "/pid";
    }

    protected Integer getServerPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)MongoDBServer.PORT);
    }

    protected String getConfFile() {
        return this.getRunDir() + "/mongo.conf";
    }

    protected String getRootUsername() {
        return (String)this.entity.config().get((ConfigKey.HasConfigKey)AbstractMongoDBServer.ROOT_USERNAME);
    }

    protected ImmutableList.Builder<String> getArgsBuilderWithDefaults(AbstractMongoDBServer server) {
        ImmutableList.Builder<String> builder = this.getArgsBuilderWithNoAuthentication(server);
        if (MongoDBAuthenticationUtils.usesAuthentication((Entity)this.entity)) {
            builder.add((Object[])new String[]{"--keyFile", (String)this.entity.getAttribute(AbstractMongoDBServer.MONGODB_KEYFILE_DESTINATION)});
        }
        return builder;
    }

    protected ImmutableList.Builder<String> getArgsBuilderWithNoAuthentication(AbstractMongoDBServer server) {
        Integer port = (Integer)server.getAttribute((AttributeSensor)MongoDBServer.PORT);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new String[]{"--config", this.getConfFile()});
        builder.add((Object[])new String[]{"--pidfilepath", this.getPidFile()});
        builder.add((Object[])new String[]{"--logpath", this.getLogFile()});
        builder.add((Object[])new String[]{"--port", port.toString()});
        builder.add((Object)"--fork");
        return builder;
    }

    protected void launch(ImmutableList.Builder<String> argsBuilder) {
        String args = Joiner.on((String)" ").join((Iterable)argsBuilder.build());
        String command = String.format("%s/bin/mongod %s >> out.log 2>> err.log < /dev/null", this.getExpandedInstallDir(), args);
        this.newScript((String)"launching").setFlag((ConfigKey)SshTool.PROP_CONNECT_TIMEOUT, (Object)Long.valueOf((long)Duration.TEN_SECONDS.toMilliseconds())).updateTaskAndFailOnNonZeroResultCode().body.append((CharSequence)command).execute();
    }
}

