/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.templates.customize;

import org.apache.brooklyn.location.jclouds.templates.customize.TemplateOptionCustomizer;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeyPairOption
implements TemplateOptionCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(KeyPairOption.class);

    KeyPairOption() {
    }

    @Override
    public void apply(TemplateOptions t, ConfigBag props, Object v) {
        if (t instanceof EC2TemplateOptions) {
            ((EC2TemplateOptions)t).keyPair(v.toString());
        } else if (t instanceof NovaTemplateOptions) {
            ((NovaTemplateOptions)t).keyPairName(v.toString());
        } else if (t instanceof CloudStackTemplateOptions) {
            ((CloudStackTemplateOptions)t).keyPair(v.toString());
        } else {
            LOG.info("ignoring keyPair({}) in VM creation because not supported for cloud/type ({})", v, (Object)t);
        }
    }
}

