/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildOutputBuilder;
import io.fabric8.openshift.api.model.BuildOutputFluentImpl;
import io.fabric8.openshift.api.model.BuildPostCommitSpec;
import io.fabric8.openshift.api.model.BuildPostCommitSpecBuilder;
import io.fabric8.openshift.api.model.BuildPostCommitSpecFluentImpl;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildSourceBuilder;
import io.fabric8.openshift.api.model.BuildSourceFluentImpl;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildStrategyBuilder;
import io.fabric8.openshift.api.model.BuildStrategyFluentImpl;
import io.fabric8.openshift.api.model.BuildTriggerPolicy;
import io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder;
import io.fabric8.openshift.api.model.BuildTriggerPolicyFluentImpl;
import io.fabric8.openshift.api.model.SourceRevision;
import io.fabric8.openshift.api.model.SourceRevisionBuilder;
import io.fabric8.openshift.api.model.SourceRevisionFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class BuildConfigSpecFluentImpl<A extends BuildConfigSpecFluent<A>>
extends BaseFluent<A>
implements BuildConfigSpecFluent<A> {
    private Long completionDeadlineSeconds;
    private VisitableBuilder<? extends BuildOutput, ?> output;
    private VisitableBuilder<? extends BuildPostCommitSpec, ?> postCommit;
    private VisitableBuilder<? extends ResourceRequirements, ?> resources;
    private VisitableBuilder<? extends SourceRevision, ?> revision;
    private String runPolicy;
    private String serviceAccount;
    private VisitableBuilder<? extends BuildSource, ?> source;
    private VisitableBuilder<? extends BuildStrategy, ?> strategy;
    private List<VisitableBuilder<? extends BuildTriggerPolicy, ?>> triggers = new ArrayList();

    public BuildConfigSpecFluentImpl() {
    }

    public BuildConfigSpecFluentImpl(BuildConfigSpec instance) {
        this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        this.withOutput(instance.getOutput());
        this.withPostCommit(instance.getPostCommit());
        this.withResources(instance.getResources());
        this.withRevision(instance.getRevision());
        this.withRunPolicy(instance.getRunPolicy());
        this.withServiceAccount(instance.getServiceAccount());
        this.withSource(instance.getSource());
        this.withStrategy(instance.getStrategy());
        this.withTriggers(instance.getTriggers());
    }

    @Override
    public Long getCompletionDeadlineSeconds() {
        return this.completionDeadlineSeconds;
    }

    @Override
    public A withCompletionDeadlineSeconds(Long completionDeadlineSeconds) {
        this.completionDeadlineSeconds = completionDeadlineSeconds;
        return (A)this;
    }

    @Override
    public BuildOutput getOutput() {
        return this.output != null ? (BuildOutput)this.output.build() : null;
    }

    @Override
    public A withOutput(BuildOutput output) {
        this._visitables.remove(this.output);
        if (output != null) {
            this.output = new BuildOutputBuilder(output);
            this._visitables.add(this.output);
        }
        return (A)this;
    }

    @Override
    public BuildConfigSpecFluent.OutputNested<A> withNewOutput() {
        return new OutputNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.OutputNested<A> withNewOutputLike(BuildOutput item) {
        return new OutputNestedImpl(item);
    }

    @Override
    public BuildConfigSpecFluent.OutputNested<A> editOutput() {
        return this.withNewOutputLike(this.getOutput());
    }

    @Override
    public BuildConfigSpecFluent.OutputNested<A> editOrNewOutput() {
        return this.withNewOutputLike(this.getOutput() != null ? this.getOutput() : new BuildOutputBuilder().build());
    }

    @Override
    public BuildConfigSpecFluent.OutputNested<A> editOrNewOutputLike(BuildOutput item) {
        return this.withNewOutputLike(this.getOutput() != null ? this.getOutput() : item);
    }

    @Override
    public BuildPostCommitSpec getPostCommit() {
        return this.postCommit != null ? (BuildPostCommitSpec)this.postCommit.build() : null;
    }

    @Override
    public A withPostCommit(BuildPostCommitSpec postCommit) {
        this._visitables.remove(this.postCommit);
        if (postCommit != null) {
            this.postCommit = new BuildPostCommitSpecBuilder(postCommit);
            this._visitables.add(this.postCommit);
        }
        return (A)this;
    }

    @Override
    public BuildConfigSpecFluent.PostCommitNested<A> withNewPostCommit() {
        return new PostCommitNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.PostCommitNested<A> withNewPostCommitLike(BuildPostCommitSpec item) {
        return new PostCommitNestedImpl(item);
    }

    @Override
    public BuildConfigSpecFluent.PostCommitNested<A> editPostCommit() {
        return this.withNewPostCommitLike(this.getPostCommit());
    }

    @Override
    public BuildConfigSpecFluent.PostCommitNested<A> editOrNewPostCommit() {
        return this.withNewPostCommitLike(this.getPostCommit() != null ? this.getPostCommit() : new BuildPostCommitSpecBuilder().build());
    }

    @Override
    public BuildConfigSpecFluent.PostCommitNested<A> editOrNewPostCommitLike(BuildPostCommitSpec item) {
        return this.withNewPostCommitLike(this.getPostCommit() != null ? this.getPostCommit() : item);
    }

    @Override
    public ResourceRequirements getResources() {
        return this.resources != null ? (ResourceRequirements)this.resources.build() : null;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this._visitables.remove(this.resources);
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (A)this;
    }

    @Override
    public BuildConfigSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public BuildConfigSpecFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public BuildConfigSpecFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourceRequirementsBuilder().build());
    }

    @Override
    public BuildConfigSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    public SourceRevision getRevision() {
        return this.revision != null ? (SourceRevision)this.revision.build() : null;
    }

    @Override
    public A withRevision(SourceRevision revision) {
        this._visitables.remove(this.revision);
        if (revision != null) {
            this.revision = new SourceRevisionBuilder(revision);
            this._visitables.add(this.revision);
        }
        return (A)this;
    }

    @Override
    public BuildConfigSpecFluent.RevisionNested<A> withNewRevision() {
        return new RevisionNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item) {
        return new RevisionNestedImpl(item);
    }

    @Override
    public BuildConfigSpecFluent.RevisionNested<A> editRevision() {
        return this.withNewRevisionLike(this.getRevision());
    }

    @Override
    public BuildConfigSpecFluent.RevisionNested<A> editOrNewRevision() {
        return this.withNewRevisionLike(this.getRevision() != null ? this.getRevision() : new SourceRevisionBuilder().build());
    }

    @Override
    public BuildConfigSpecFluent.RevisionNested<A> editOrNewRevisionLike(SourceRevision item) {
        return this.withNewRevisionLike(this.getRevision() != null ? this.getRevision() : item);
    }

    @Override
    public String getRunPolicy() {
        return this.runPolicy;
    }

    @Override
    public A withRunPolicy(String runPolicy) {
        this.runPolicy = runPolicy;
        return (A)this;
    }

    @Override
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @Override
    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)this;
    }

    @Override
    public BuildSource getSource() {
        return this.source != null ? (BuildSource)this.source.build() : null;
    }

    @Override
    public A withSource(BuildSource source) {
        this._visitables.remove(this.source);
        if (source != null) {
            this.source = new BuildSourceBuilder(source);
            this._visitables.add(this.source);
        }
        return (A)this;
    }

    @Override
    public BuildConfigSpecFluent.SourceNested<A> withNewSource() {
        return new SourceNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.SourceNested<A> withNewSourceLike(BuildSource item) {
        return new SourceNestedImpl(item);
    }

    @Override
    public BuildConfigSpecFluent.SourceNested<A> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    @Override
    public BuildConfigSpecFluent.SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : new BuildSourceBuilder().build());
    }

    @Override
    public BuildConfigSpecFluent.SourceNested<A> editOrNewSourceLike(BuildSource item) {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : item);
    }

    @Override
    public BuildStrategy getStrategy() {
        return this.strategy != null ? (BuildStrategy)this.strategy.build() : null;
    }

    @Override
    public A withStrategy(BuildStrategy strategy) {
        this._visitables.remove(this.strategy);
        if (strategy != null) {
            this.strategy = new BuildStrategyBuilder(strategy);
            this._visitables.add(this.strategy);
        }
        return (A)this;
    }

    @Override
    public BuildConfigSpecFluent.StrategyNested<A> withNewStrategy() {
        return new StrategyNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.StrategyNested<A> withNewStrategyLike(BuildStrategy item) {
        return new StrategyNestedImpl(item);
    }

    @Override
    public BuildConfigSpecFluent.StrategyNested<A> editStrategy() {
        return this.withNewStrategyLike(this.getStrategy());
    }

    @Override
    public BuildConfigSpecFluent.StrategyNested<A> editOrNewStrategy() {
        return this.withNewStrategyLike(this.getStrategy() != null ? this.getStrategy() : new BuildStrategyBuilder().build());
    }

    @Override
    public BuildConfigSpecFluent.StrategyNested<A> editOrNewStrategyLike(BuildStrategy item) {
        return this.withNewStrategyLike(this.getStrategy() != null ? this.getStrategy() : item);
    }

    @Override
    public A addToTriggers(BuildTriggerPolicy ... items) {
        for (BuildTriggerPolicy item : items) {
            BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
            this._visitables.add(builder);
            this.triggers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTriggers(BuildTriggerPolicy ... items) {
        for (BuildTriggerPolicy item : items) {
            BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
            this._visitables.remove(builder);
            this.triggers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<BuildTriggerPolicy> getTriggers() {
        return BuildConfigSpecFluentImpl.build(this.triggers);
    }

    @Override
    public A withTriggers(List<BuildTriggerPolicy> triggers) {
        this._visitables.removeAll(this.triggers);
        this.triggers.clear();
        if (triggers != null) {
            for (BuildTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withTriggers(BuildTriggerPolicy ... triggers) {
        this.triggers.clear();
        if (triggers != null) {
            for (BuildTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (A)this;
    }

    @Override
    public BuildConfigSpecFluent.TriggersNested<A> addNewTrigger() {
        return new TriggersNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.TriggersNested<A> addNewTriggerLike(BuildTriggerPolicy item) {
        return new TriggersNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildConfigSpecFluentImpl that = (BuildConfigSpecFluentImpl)o;
        if (this.completionDeadlineSeconds != null ? !this.completionDeadlineSeconds.equals(that.completionDeadlineSeconds) : that.completionDeadlineSeconds != null) {
            return false;
        }
        if (this.output != null ? !this.output.equals(that.output) : that.output != null) {
            return false;
        }
        if (this.postCommit != null ? !this.postCommit.equals(that.postCommit) : that.postCommit != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        if (this.runPolicy != null ? !this.runPolicy.equals(that.runPolicy) : that.runPolicy != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        return !(this.triggers != null ? !this.triggers.equals(that.triggers) : that.triggers != null);
    }

    public class TriggersNestedImpl<N>
    extends BuildTriggerPolicyFluentImpl<BuildConfigSpecFluent.TriggersNested<N>>
    implements BuildConfigSpecFluent.TriggersNested<N>,
    Nested<N> {
        private final BuildTriggerPolicyBuilder builder;

        TriggersNestedImpl(BuildTriggerPolicy item) {
            this.builder = new BuildTriggerPolicyBuilder(this, item);
        }

        TriggersNestedImpl() {
            this.builder = new BuildTriggerPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.addToTriggers(this.builder.build());
        }

        @Override
        public N endTrigger() {
            return this.and();
        }
    }

    public class StrategyNestedImpl<N>
    extends BuildStrategyFluentImpl<BuildConfigSpecFluent.StrategyNested<N>>
    implements BuildConfigSpecFluent.StrategyNested<N>,
    Nested<N> {
        private final BuildStrategyBuilder builder;

        StrategyNestedImpl(BuildStrategy item) {
            this.builder = new BuildStrategyBuilder(this, item);
        }

        StrategyNestedImpl() {
            this.builder = new BuildStrategyBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.withStrategy(this.builder.build());
        }

        @Override
        public N endStrategy() {
            return this.and();
        }
    }

    public class SourceNestedImpl<N>
    extends BuildSourceFluentImpl<BuildConfigSpecFluent.SourceNested<N>>
    implements BuildConfigSpecFluent.SourceNested<N>,
    Nested<N> {
        private final BuildSourceBuilder builder;

        SourceNestedImpl(BuildSource item) {
            this.builder = new BuildSourceBuilder(this, item);
        }

        SourceNestedImpl() {
            this.builder = new BuildSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.withSource(this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }

    public class RevisionNestedImpl<N>
    extends SourceRevisionFluentImpl<BuildConfigSpecFluent.RevisionNested<N>>
    implements BuildConfigSpecFluent.RevisionNested<N>,
    Nested<N> {
        private final SourceRevisionBuilder builder;

        RevisionNestedImpl(SourceRevision item) {
            this.builder = new SourceRevisionBuilder(this, item);
        }

        RevisionNestedImpl() {
            this.builder = new SourceRevisionBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.withRevision(this.builder.build());
        }

        @Override
        public N endRevision() {
            return this.and();
        }
    }

    public class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<BuildConfigSpecFluent.ResourcesNested<N>>
    implements BuildConfigSpecFluent.ResourcesNested<N>,
    Nested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    public class PostCommitNestedImpl<N>
    extends BuildPostCommitSpecFluentImpl<BuildConfigSpecFluent.PostCommitNested<N>>
    implements BuildConfigSpecFluent.PostCommitNested<N>,
    Nested<N> {
        private final BuildPostCommitSpecBuilder builder;

        PostCommitNestedImpl(BuildPostCommitSpec item) {
            this.builder = new BuildPostCommitSpecBuilder(this, item);
        }

        PostCommitNestedImpl() {
            this.builder = new BuildPostCommitSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.withPostCommit(this.builder.build());
        }

        @Override
        public N endPostCommit() {
            return this.and();
        }
    }

    public class OutputNestedImpl<N>
    extends BuildOutputFluentImpl<BuildConfigSpecFluent.OutputNested<N>>
    implements BuildConfigSpecFluent.OutputNested<N>,
    Nested<N> {
        private final BuildOutputBuilder builder;

        OutputNestedImpl(BuildOutput item) {
            this.builder = new BuildOutputBuilder(this, item);
        }

        OutputNestedImpl() {
            this.builder = new BuildOutputBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.withOutput(this.builder.build());
        }

        @Override
        public N endOutput() {
            return this.and();
        }
    }
}

