/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.javalang;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import java.lang.reflect.Field;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Equals {
    private static final Logger log = LoggerFactory.getLogger(Equals.class);

    public static boolean objects(Object o1, Object o2, Object ... oo) {
        if (!Objects.equal((Object)o1, (Object)o2)) {
            return false;
        }
        for (Object o : oo) {
            if (Objects.equal((Object)o1, (Object)o)) continue;
            return false;
        }
        return true;
    }

    @Beta
    public static boolean approximately(Object o1, Object o2) {
        if (o1 instanceof Number && o2 instanceof Number) {
            return Math.abs(((Number)o2).doubleValue() - ((Number)o1).doubleValue()) < 0.001;
        }
        return Objects.equal((Object)o1, (Object)o2);
    }

    @Beta
    public static boolean approximately(Object o1, Object o2, Object o3, Object ... oo) {
        if (!Equals.approximately(o1, o2)) {
            return false;
        }
        if (!Equals.approximately(o1, o3)) {
            return false;
        }
        for (Object o : oo) {
            if (Equals.approximately(o1, o)) continue;
            return false;
        }
        return true;
    }

    public static void dumpReflectiveEquals(Object o1, Object o2) {
        log.info("Comparing: " + o1 + " " + o2);
        Class<?> clazz = o1.getClass();
        while (!clazz.equals(Object.class)) {
            log.info("  fields in: " + clazz);
            for (Field f : clazz.getDeclaredFields()) {
                f.setAccessible(true);
                try {
                    log.info("    " + (Objects.equal((Object)f.get(o1), (Object)f.get(o2)) ? "==" : "!=") + " " + f.getName() + " " + f.get(o1) + " " + f.get(o2) + " (" + Equals.classOf(f.get(o1)) + " " + Equals.classOf(f.get(o2) + ")"));
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal(e);
                    log.info("    <error> " + e);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    private static String classOf(Object o) {
        if (o == null) {
            return null;
        }
        return o.getClass().toString();
    }
}

