/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.authentication;

import com.mongodb.MongoInternalException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;

public final class NativeAuthenticationHelper {
    private static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");

    public static String createAuthenticationHash(String userName, char[] password) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(userName.length() + 20 + password.length);
        try {
            bout.write(userName.getBytes(UTF_8_CHARSET));
            bout.write(":mongo:".getBytes(UTF_8_CHARSET));
            for (char ch : password) {
                if (ch >= '\u0080') {
                    throw new IllegalArgumentException("can't handle non-ascii passwords yet");
                }
                bout.write((byte)ch);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("impossible", ioe);
        }
        return NativeAuthenticationHelper.hexMD5(bout.toByteArray());
    }

    public static BsonDocument getAuthCommand(String userName, char[] password, String nonce) {
        return NativeAuthenticationHelper.getAuthCommand(userName, NativeAuthenticationHelper.createAuthenticationHash(userName, password), nonce);
    }

    public static BsonDocument getAuthCommand(String userName, String authHash, String nonce) {
        String key = nonce + userName + authHash;
        BsonDocument cmd = new BsonDocument();
        cmd.put("authenticate", new BsonInt32(1));
        cmd.put("user", new BsonString(userName));
        cmd.put("nonce", new BsonString(nonce));
        cmd.put("key", new BsonString(NativeAuthenticationHelper.hexMD5(key.getBytes(UTF_8_CHARSET))));
        return cmd;
    }

    public static BsonDocument getNonceCommand() {
        return new BsonDocument("getnonce", new BsonInt32(1));
    }

    static String hexMD5(byte[] data) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(data);
            byte[] digest = md5.digest();
            return NativeAuthenticationHelper.toHex(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoInternalException("Error - this implementation of Java doesn't support MD5.", e);
        }
    }

    static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            String s = Integer.toHexString(0xFF & aByte);
            if (s.length() < 2) {
                sb.append("0");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private NativeAuthenticationHelper() {
    }
}

