/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.resource;

import aQute.lib.collections.MultiMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentResource
implements Resource {
    public Namespace[] namespaces;
    public byte[] sha;
    transient MultiMap<String, Capability> tcapabilities;
    transient MultiMap<String, Requirement> trequirements;

    public PersistentResource() {
    }

    public PersistentResource(byte[] sha, List<Capability> caps, List<Requirement> reqs) {
        this.sha = sha;
        MultiMap<String, Capability> capMap = new MultiMap<String, Capability>();
        for (Capability cap : caps) {
            capMap.add(cap.getNamespace(), cap);
        }
        MultiMap<String, Requirement> reqMap = new MultiMap<String, Requirement>();
        for (Requirement req : reqs) {
            reqMap.add(req.getNamespace(), req);
        }
        HashSet names = new HashSet(capMap.keySet());
        names.addAll(reqMap.keySet());
        this.namespaces = new Namespace[names.size()];
        int i = 0;
        for (String name : names) {
            List capabilities;
            Namespace ns = new Namespace();
            List requirements = (List)reqMap.get(name);
            if (requirements.size() > 0) {
                ns.requirements = new RCData[requirements.size()];
                int rqi = 0;
                for (Requirement r : requirements) {
                    ns.requirements[rqi] = PersistentResource.getData(r.getAttributes(), r.getDirectives());
                }
            }
            if ((capabilities = (List)capMap.get(name)).size() > 0) {
                ns.capabilities = new RCData[capabilities.size()];
                int rci = 0;
                for (Capability c : capabilities) {
                    ns.requirements[rci] = PersistentResource.getData(c.getAttributes(), c.getDirectives());
                }
            }
            this.namespaces[i] = ns;
        }
        Arrays.sort(this.namespaces);
    }

    public List<Capability> getCapabilities(String namespace) {
        this.init();
        if (namespace == null) {
            return this.tcapabilities.allValues();
        }
        List list = (List)this.tcapabilities.get(namespace);
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public List<Requirement> getRequirements(String namespace) {
        this.init();
        if (namespace == null) {
            return this.trequirements.allValues();
        }
        List list = (List)this.trequirements.get(namespace);
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    private void init() {
        this.tcapabilities = new MultiMap();
        this.trequirements = new MultiMap();
        for (int i = 0; i < this.namespaces.length; ++i) {
            Namespace ns = this.namespaces[i];
            for (RCData rs : ns.capabilities) {
                this.tcapabilities.add(ns.name, new RC(rs, ns.name));
            }
            for (RCData rs : ns.requirements) {
                this.trequirements.add(ns.name, new RC(rs, ns.name));
            }
        }
    }

    static int getType(Object value) {
        if (value == null || value instanceof String) {
            return DataType.STRING.ordinal();
        }
        if (value instanceof Version) {
            return DataType.VERSION.ordinal();
        }
        if (value instanceof Long) {
            return DataType.LONG.ordinal();
        }
        if (value instanceof Double) {
            return DataType.DOUBLE.ordinal();
        }
        return DataType.STRING.ordinal();
    }

    private static Attr getAttr(String key, Object value, boolean directive) {
        Attr attr = new Attr();
        attr.key = key;
        if (directive) {
            attr.type = DataType.STRING.ordinal();
            attr.value = value.toString();
            attr.directive = true;
            return attr;
        }
        attr.value = value + "";
        if (value instanceof Collection) {
            if (((Collection)value).size() > 0) {
                Object member = ((Collection)value).iterator().next();
                attr.type = PersistentResource.getType(member);
            } else {
                attr.type = DataType.STRING.ordinal();
            }
            return attr;
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length > 0) {
                Object member = Array.get(value, 0);
                attr.type = PersistentResource.getType(member);
            } else {
                attr.type = DataType.STRING.ordinal();
            }
        }
        attr.type = PersistentResource.getType(value);
        return attr;
    }

    public static RCData getData(Map<String, Object> attributes, Map<String, String> directives) {
        RCData data = new RCData();
        ArrayList<Attr> props = new ArrayList<Attr>(attributes.size() + directives.size());
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            props.add(PersistentResource.getAttr(entry.getKey(), entry.getValue(), false));
        }
        for (Map.Entry<String, Object> entry : directives.entrySet()) {
            props.add(PersistentResource.getAttr(entry.getKey(), entry.getValue(), true));
            ++data.directives;
        }
        Collections.sort(props);
        data.properties = props.toArray(new Attr[props.size()]);
        return data;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RC
    implements Requirement,
    Capability {
        final Attr[] props;
        final int directivesCount;
        final String namespace;
        Map<String, Object> attributes;
        Map<String, String> directives;

        public RC(RCData data, String ns) {
            this.props = data.properties;
            this.directivesCount = data.directives;
            this.namespace = ns;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Resource getResource() {
            return PersistentResource.this;
        }

        public Map<String, Object> getAttributes() {
            if (this.attributes != null) {
                return this.attributes;
            }
            this.attributes = new PropMap<Object>(false);
            return this.attributes;
        }

        public Map<String, String> getDirectives() {
            if (this.directives != null) {
                return this.directives;
            }
            this.directives = new PropMap<String>(true);
            return this.directives;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PropMap<V>
        implements Map<String, V> {
            boolean directive;

            public PropMap(boolean directive) {
                this.directive = directive;
            }

            @Override
            public int size() {
                return this.directive ? RC.this.directivesCount : RC.this.props.length - RC.this.directivesCount;
            }

            @Override
            public boolean isEmpty() {
                return RC.this.props.length == 0;
            }

            @Override
            public boolean containsKey(Object key) {
                return this.get(key) != null;
            }

            @Override
            public boolean containsValue(Object value) {
                if (value == null) {
                    return false;
                }
                for (Attr attr : RC.this.props) {
                    if (!value.equals(attr.getValue())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public V get(Object key) {
                Attr attr;
                if (key instanceof String && (attr = this.search((String)key)) != null) {
                    return (V)attr.getValue();
                }
                return null;
            }

            @Override
            public V put(String key, V value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public V remove(Object key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends String, ? extends V> m) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Set<String> keySet() {
                HashSet<String> result = new HashSet<String>();
                for (Attr attr : RC.this.props) {
                    if (attr.directive != this.directive) continue;
                    result.add(attr.key);
                }
                return result;
            }

            @Override
            public Collection<V> values() {
                ArrayList<Object> values = new ArrayList<Object>();
                for (Attr attr : RC.this.props) {
                    if (attr.directive != this.directive) continue;
                    values.add(attr.getValue());
                }
                return values;
            }

            @Override
            public Set<Map.Entry<String, V>> entrySet() {
                HashSet<Map.Entry<String, V>> result = new HashSet<Map.Entry<String, V>>();
                for (final Attr attr : RC.this.props) {
                    if (attr.directive != this.directive) continue;
                    result.add(new Map.Entry<String, V>(){

                        @Override
                        public String getKey() {
                            return attr.key;
                        }

                        @Override
                        public V getValue() {
                            return attr.getValue();
                        }

                        @Override
                        public V setValue(V value) {
                            throw new UnsupportedOperationException();
                        }
                    });
                }
                return result;
            }

            private Attr search(String key) {
                int low = 0;
                int high = RC.this.props.length - 1;
                while (low <= high) {
                    int mid = low + high >>> 1;
                    Attr midVal = RC.this.props[mid];
                    int r = midVal.key.compareTo(key);
                    if (r < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (r > 0) {
                        high = mid - 1;
                        continue;
                    }
                    Attr attr = RC.this.props[mid];
                    if (attr.directive == this.directive) {
                        return attr;
                    }
                    if (++mid <= high && RC.this.props[mid].key.equals(key)) {
                        return RC.this.props[mid];
                    }
                    if ((mid -= 2) < 0 || !RC.this.props[mid].key.equals(key)) break;
                    return RC.this.props[mid];
                }
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Attr
    implements Comparable<Attr> {
        public String key;
        public int type;
        public Object value;
        public boolean directive = false;
        transient Object converted;

        @Override
        public int compareTo(Attr o) {
            return this.key.compareTo(o.key);
        }

        public Object getValue() {
            if (this.converted == null && this.value != null) {
                DataType t = DataType.values()[this.type];
                if (this.value instanceof Collection) {
                    Object[] cnv = ((Collection)this.value).toArray();
                    for (int i = 0; i < cnv.length; ++i) {
                        cnv[i] = this.convert(t, (String)cnv[i]);
                    }
                    this.converted = cnv;
                } else {
                    this.converted = this.convert(t, (String)this.value);
                }
            }
            return this.converted;
        }

        private Object convert(DataType t, String value) {
            switch (t) {
                case DOUBLE: {
                    return Double.valueOf(value);
                }
                case LONG: {
                    return Long.valueOf(value);
                }
                case STRING: {
                    return value;
                }
                case VERSION: {
                    return Version.parseVersion((String)value);
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        STRING,
        LONG,
        DOUBLE,
        VERSION;

    }

    public static class RCData {
        public Attr[] properties;
        public int directives;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Namespace
    implements Comparable<Namespace> {
        public String name;
        public RCData[] capabilities;
        public RCData[] requirements;

        @Override
        public int compareTo(Namespace o) {
            return this.name.compareTo(o.name);
        }
    }
}

