/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;

public enum BillingCycle {
    HOURLY("hourly"),
    MONTHLY("monthly"),
    UNRECOGNIZED("");

    private static final List<BillingCycle> values;
    private final String value;

    private BillingCycle(String value) {
        this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value cannot be null");
    }

    public String value() {
        return this.value;
    }

    public static BillingCycle fromValue(String value) {
        return (BillingCycle)((Object)Iterables.tryFind(values, BillingCycle.hasValue(value)).or((Object)UNRECOGNIZED));
    }

    private static Predicate<BillingCycle> hasValue(final String value) {
        return new Predicate<BillingCycle>(){

            public boolean apply(BillingCycle input) {
                return input.value.equalsIgnoreCase(value);
            }
        };
    }

    static {
        values = Arrays.asList(BillingCycle.values());
    }
}

