/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.config;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.TlsVersion;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.docker.suppliers.DockerSSLContextSupplier;
import org.jclouds.domain.Credentials;
import org.jclouds.http.okhttp.OkHttpClientSupplier;
import org.jclouds.location.Provider;

@Singleton
public class DockerOkHttpClientSupplier
implements OkHttpClientSupplier {
    private final DockerSSLContextSupplier dockerSSLContextSupplier;
    private final Supplier<Credentials> creds;

    @Inject
    DockerOkHttpClientSupplier(DockerSSLContextSupplier dockerSSLContextSupplier, @Provider Supplier<Credentials> creds) {
        this.dockerSSLContextSupplier = dockerSSLContextSupplier;
        this.creds = creds;
    }

    public OkHttpClient get() {
        OkHttpClient client = new OkHttpClient();
        ConnectionSpec tlsSpec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_0, TlsVersion.TLS_1_1, TlsVersion.TLS_1_2}).build();
        ConnectionSpec cleartextSpec = new ConnectionSpec.Builder(ConnectionSpec.CLEARTEXT).build();
        client.setConnectionSpecs((List)ImmutableList.of((Object)tlsSpec, (Object)cleartextSpec));
        if (new File(((Credentials)this.creds.get()).identity).isFile() && new File(((Credentials)this.creds.get()).credential).isFile()) {
            client.setSslSocketFactory(this.dockerSSLContextSupplier.get().getSocketFactory());
        }
        return client;
    }
}

