/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.shell.InvertedShell;
import org.apache.sshd.server.shell.InvertedShellWrapper;
import org.apache.sshd.server.shell.ProcessShell;

public class ProcessShellFactory
extends AbstractLoggingBean
implements Factory<Command> {
    private List<String> command;

    public ProcessShellFactory() {
        this(Collections.emptyList());
    }

    public ProcessShellFactory(String ... command) {
        this(GenericUtils.isEmpty(command) ? Collections.emptyList() : Arrays.asList(command));
    }

    public ProcessShellFactory(List<String> command) {
        this.command = ValidateUtils.checkNotNullAndNotEmpty(command, "No command", new Object[0]);
    }

    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(String ... command) {
        this.setCommand(GenericUtils.isEmpty(command) ? Collections.emptyList() : Arrays.asList(command));
    }

    public void setCommand(List<String> command) {
        this.command = ValidateUtils.checkNotNullAndNotEmpty(command, "No command", new Object[0]);
    }

    @Override
    public Command create() {
        return new InvertedShellWrapper(this.createInvertedShell());
    }

    protected InvertedShell createInvertedShell() {
        return new ProcessShell(this.resolveEffectiveCommand(this.getCommand()));
    }

    protected List<String> resolveEffectiveCommand(List<String> original) {
        if (!OsUtils.isWin32()) {
            return original;
        }
        if (GenericUtils.size(original) <= 1) {
            return original;
        }
        String cmdName = original.get(0);
        if ("cmd.exe".equalsIgnoreCase(cmdName)) {
            return original;
        }
        return Arrays.asList("cmd.exe", "/C", GenericUtils.join(original, ' '));
    }
}

