/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs.proxy;

import java.util.Map;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.objs.proxy.InternalFactory;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.exceptions.Exceptions;

public class InternalPolicyFactory
extends InternalFactory {
    public InternalPolicyFactory(ManagementContextInternal managementContext) {
        super(managementContext);
    }

    public <T extends Policy> T createPolicy(PolicySpec<T> spec) {
        if (spec.getFlags().containsKey("parent")) {
            throw new IllegalArgumentException("Spec's flags must not contain parent; use spec.parent() instead for " + spec);
        }
        try {
            Class clazz = spec.getType();
            Policy pol = (Policy)this.construct(clazz, (AbstractBrooklynObjectSpec<?, ?>)spec, null);
            AbstractPolicy policy = (AbstractPolicy)pol;
            if (spec.getDisplayName() != null) {
                policy.setDisplayName(spec.getDisplayName());
            }
            if (spec.getCatalogItemId() != null) {
                policy.setCatalogItemIdAndSearchPath(spec.getCatalogItemId(), spec.getCatalogItemIdSearchPath());
            }
            pol.tags().addTags((Iterable)spec.getTags());
            if (InternalPolicyFactory.isNewStyle(clazz)) {
                policy.setManagementContext(this.managementContext);
                Map<String, Object> config = ConfigBag.newInstance().putAll(spec.getFlags()).putAll(spec.getConfig()).getAllConfig();
                policy.configure((Map)MutableMap.copyOf(config));
            }
            for (Map.Entry entry : spec.getConfig().entrySet()) {
                pol.config().set((ConfigKey)entry.getKey(), entry.getValue());
            }
            policy.init();
            return (T)pol;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public <T extends Enricher> T createEnricher(EnricherSpec<T> spec) {
        if (spec.getFlags().containsKey("parent")) {
            throw new IllegalArgumentException("Spec's flags must not contain parent; use spec.parent() instead for " + spec);
        }
        try {
            Class clazz = spec.getType();
            Enricher enricher = (Enricher)this.construct(clazz, (AbstractBrooklynObjectSpec<?, ?>)spec, null);
            AbstractEnricher theEnricher = (AbstractEnricher)enricher;
            if (spec.getDisplayName() != null) {
                theEnricher.setDisplayName(spec.getDisplayName());
            }
            if (spec.getCatalogItemId() != null) {
                theEnricher.setCatalogItemIdAndSearchPath(spec.getCatalogItemId(), spec.getCatalogItemIdSearchPath());
            }
            enricher.tags().addTags((Iterable)spec.getTags());
            if (InternalPolicyFactory.isNewStyle(clazz)) {
                theEnricher.setManagementContext(this.managementContext);
                Map<String, Object> config = ConfigBag.newInstance().putAll(spec.getFlags()).putAll(spec.getConfig()).getAllConfig();
                theEnricher.configure((Map)MutableMap.copyOf(config));
            }
            for (Map.Entry entry : spec.getConfig().entrySet()) {
                enricher.config().set((ConfigKey)entry.getKey(), entry.getValue());
            }
            theEnricher.init();
            return (T)enricher;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public <T extends Policy> T constructPolicy(Class<T> clazz) {
        return (T)((Policy)super.constructNewStyle(clazz));
    }

    public <T extends Enricher> T constructEnricher(Class<T> clazz) {
        return (T)((Enricher)super.constructNewStyle(clazz));
    }

    public <T extends Feed> T constructFeed(Class<T> clazz) {
        return (T)((Feed)super.constructNewStyle(clazz));
    }
}

