/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.ui.modularity.module.registry;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.brooklyn.ui.modularity.module.api.UiModule;
import org.apache.brooklyn.ui.modularity.module.api.UiModuleRegistry;

@Path(value="/")
public class RestUiModuleRegistry {
    private UiModuleRegistry uiModuleRegistry;
    private static final Function<UiModule, String> GET_NAME_FUNCTION = new Function<UiModule, String>(){

        public String apply(UiModule input) {
            if (input != null) {
                return input.getName();
            }
            return "";
        }
    };

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public Collection<UiModule> getRegisteredWebComponents() {
        return Ordering.natural().onResultOf(GET_NAME_FUNCTION).immutableSortedCopy(Iterables.transform((Iterable)this.uiModuleRegistry.getRegisteredModules(), x -> UiModule.Utils.copyUiModule((UiModule)x)));
    }

    public void setUiModuleRegistry(UiModuleRegistry uiModuleRegistry) {
        this.uiModuleRegistry = uiModuleRegistry;
    }
}

