/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.zookeeper;

import com.google.common.base.Functions;
import com.google.common.base.Objects;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.entity.java.JavaSoftwareProcessDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.entity.zookeeper.ZooKeeperNode;
import org.apache.brooklyn.feed.jmx.JmxAttributePollConfig;
import org.apache.brooklyn.feed.jmx.JmxFeed;
import org.apache.brooklyn.feed.jmx.JmxHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZooKeeperImpl
extends SoftwareProcessImpl
implements ZooKeeperNode {
    private static final Logger log = LoggerFactory.getLogger(AbstractZooKeeperImpl.class);
    private static final ObjectName ZOOKEEPER_MBEAN = JmxHelper.createObjectName((String)"org.apache.ZooKeeperService:name0=StandaloneServer_port-1");
    private volatile JmxFeed jmxFeed;

    @Override
    public Integer getZookeeperPort() {
        return (Integer)this.getAttribute((AttributeSensor)ZOOKEEPER_PORT);
    }

    @Override
    public String getHostname() {
        return (String)this.getAttribute(HOSTNAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForServiceUp(long duration, TimeUnit units) {
        super.waitForServiceUp(duration, units);
        if (((JavaSoftwareProcessDriver)this.getDriver()).isJmxEnabled()) {
            JmxHelper helper = new JmxHelper((Entity)this);
            try {
                helper.assertMBeanExistsEventually(ZOOKEEPER_MBEAN, units.toMillis(duration));
            }
            finally {
                helper.terminate();
            }
        }
    }

    protected void connectSensors() {
        this.connectServiceUpIsRunning();
        if (((JavaSoftwareProcessDriver)this.getDriver()).isJmxEnabled()) {
            this.jmxFeed = JmxFeed.builder().entity((Entity)this).period(500L, TimeUnit.MILLISECONDS).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig(OUTSTANDING_REQUESTS).objectName(ZOOKEEPER_MBEAN).attributeName("OutstandingRequests").onFailureOrException(Functions.constant((Object)-1L))).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig(PACKETS_RECEIVED).objectName(ZOOKEEPER_MBEAN).attributeName("PacketsReceived").onFailureOrException(Functions.constant((Object)-1L))).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig(PACKETS_SENT).objectName(ZOOKEEPER_MBEAN).attributeName("PacketsSent").onFailureOrException(Functions.constant((Object)-1L))).build();
        }
    }

    public void disconnectSensors() {
        if (this.jmxFeed != null) {
            this.jmxFeed.stop();
        }
        this.disconnectServiceUpIsRunning();
        super.disconnectSensors();
    }

    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("zookeeperPort", (Object)this.getZookeeperPort());
    }
}

