/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.kafka;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.feed.ConfigToAttributes;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.messaging.kafka.KafkaBroker;
import org.apache.brooklyn.entity.messaging.kafka.KafkaCluster;
import org.apache.brooklyn.entity.messaging.kafka.KafkaZooKeeper;
import org.apache.brooklyn.entity.zookeeper.ZooKeeperNode;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.CompoundRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaClusterImpl
extends AbstractEntity
implements KafkaCluster {
    public static final Logger log = LoggerFactory.getLogger(KafkaClusterImpl.class);

    public void init() {
        super.init();
        this.sensors().set(SERVICE_UP, (Object)false);
        ConfigToAttributes.apply((Entity)this, (AttributeSensorAndConfigKey)BROKER_SPEC);
        ConfigToAttributes.apply((Entity)this, (AttributeSensorAndConfigKey)ZOOKEEPER);
        ConfigToAttributes.apply((Entity)this, (AttributeSensorAndConfigKey)ZOOKEEPER_SPEC);
        log.debug("creating zookeeper child for {}", (Object)this);
        ZooKeeperNode zookeeper = (ZooKeeperNode)this.getAttribute((AttributeSensor)ZOOKEEPER);
        if (zookeeper == null) {
            EntitySpec zookeeperSpec = (EntitySpec)this.getAttribute((AttributeSensor)ZOOKEEPER_SPEC);
            if (zookeeperSpec == null) {
                log.debug("creating zookeeper using default spec for {}", (Object)this);
                zookeeperSpec = EntitySpec.create(KafkaZooKeeper.class);
                this.sensors().set((AttributeSensor)ZOOKEEPER_SPEC, (Object)zookeeperSpec);
            } else {
                log.debug("creating zookeeper using custom spec for {}", (Object)this);
            }
            zookeeper = (ZooKeeperNode)this.addChild(zookeeperSpec);
            this.sensors().set((AttributeSensor)ZOOKEEPER, (Object)zookeeper);
        }
        log.debug("creating cluster child for {}", (Object)this);
        EntitySpec brokerSpec = (EntitySpec)this.getAttribute((AttributeSensor)BROKER_SPEC);
        if (brokerSpec == null) {
            log.debug("creating default broker spec for {}", (Object)this);
            brokerSpec = EntitySpec.create(KafkaBroker.class);
            this.sensors().set((AttributeSensor)BROKER_SPEC, (Object)brokerSpec);
        }
        DynamicCluster cluster = (DynamicCluster)this.addChild((EntitySpec)EntitySpec.create(DynamicCluster.class).configure((CharSequence)"memberSpec", (Object)EntitySpec.create((EntitySpec)brokerSpec).configure(KafkaBroker.ZOOKEEPER, (Object)zookeeper)));
        this.sensors().set(CLUSTER, (Object)cluster);
        this.connectSensors();
    }

    @Override
    public ZooKeeperNode getZooKeeper() {
        return (ZooKeeperNode)this.getAttribute((AttributeSensor)ZOOKEEPER);
    }

    @Override
    public DynamicCluster getCluster() {
        return (DynamicCluster)this.getAttribute(CLUSTER);
    }

    public void start(Collection<? extends Location> locations) {
        if (this.isLegacyConstruction()) {
            this.init();
        }
        locations = MutableList.copyOf((Iterable)Locations.getLocationsCheckingAncestors(locations, (Entity)this));
        Iterables.getOnlyElement((Iterable)locations);
        this.addLocations((Collection)locations);
        MutableList childrenToStart = MutableList.of((Object)this.getCluster());
        if (this.getZooKeeper().getParent() == null) {
            this.addChild((Entity)this.getZooKeeper());
        }
        if (Objects.equal((Object)this, (Object)this.getZooKeeper().getParent())) {
            childrenToStart.add(this.getZooKeeper());
        }
        Entities.invokeEffector((Entity)this, (Iterable)childrenToStart, (Effector)Startable.START, (Map)ImmutableMap.of((Object)"locations", (Object)locations)).getUnchecked();
    }

    public void stop() {
        ArrayList errors = Lists.newArrayList();
        if (this.getZooKeeper() != null && Objects.equal((Object)this, (Object)this.getZooKeeper().getParent())) {
            try {
                this.getZooKeeper().stop();
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (this.getCurrentSize() > 0) {
            try {
                this.getCluster().stop();
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        this.clearLocations();
        this.sensors().set(SERVICE_UP, (Object)false);
        if (errors.size() != 0) {
            throw new CompoundRuntimeException("Error stopping Kafka cluster", (Iterable)errors);
        }
    }

    public void restart() {
        ArrayList locations = Lists.newArrayList((Iterable)this.getLocations());
        this.stop();
        this.start(locations);
    }

    void connectSensors() {
        this.enrichers().add(((Enrichers.PropagatorBuilder)Enrichers.builder().propagatingAllBut(new Sensor[]{SERVICE_UP}).from((Entity)this.getCluster())).build());
        this.enrichers().add(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{SERVICE_UP}).from((Entity)this.getZooKeeper())).build());
    }

    public Collection<Entity> getMembers() {
        return this.getCluster().getMembers();
    }

    public boolean hasMember(Entity member) {
        return this.getCluster().hasMember(member);
    }

    public boolean addMember(Entity member) {
        return this.getCluster().addMember(member);
    }

    public boolean removeMember(Entity member) {
        return this.getCluster().removeMember(member);
    }

    public Integer getCurrentSize() {
        return this.getCluster().getCurrentSize();
    }

    public Integer resize(Integer desiredSize) {
        return this.getCluster().resize(desiredSize);
    }

    public <T extends Entity> T addMemberChild(EntitySpec<T> spec) {
        return (T)this.getCluster().addMemberChild(spec);
    }

    public <T extends Entity> T addMemberChild(T child) {
        return (T)this.getCluster().addMemberChild(child);
    }
}

