/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.conf.validators;

import org.apache.bookkeeper.common.conf.Validator;

public class RangeValidator
implements Validator {
    private final Number min;
    private final Number max;

    public static RangeValidator atLeast(Number min) {
        return new RangeValidator(min, null);
    }

    public static RangeValidator atMost(Number max) {
        return new RangeValidator(null, max);
    }

    public static RangeValidator between(Number min, Number max) {
        return new RangeValidator(min, max);
    }

    @Override
    public boolean validate(String name, Object value) {
        if (value instanceof Number) {
            Number n = (Number)value;
            if (this.min != null && n.doubleValue() < this.min.doubleValue()) {
                return false;
            }
            return this.max == null || n.doubleValue() <= this.max.doubleValue();
        }
        return false;
    }

    public String toString() {
        if (null == this.min) {
            return "[... , " + this.max + "]";
        }
        if (null == this.max) {
            return "[" + this.min + ", ...]";
        }
        return "[" + this.min + ", " + this.max + "]";
    }

    @Override
    public String documentation() {
        return this.toString();
    }

    public RangeValidator(Number min, Number max) {
        this.min = min;
        this.max = max;
    }

    public Number getMin() {
        return this.min;
    }

    public Number getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RangeValidator)) {
            return false;
        }
        RangeValidator other = (RangeValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Number this$min = this.getMin();
        Number other$min = other.getMin();
        if (this$min == null ? other$min != null : !this$min.equals(other$min)) {
            return false;
        }
        Number this$max = this.getMax();
        Number other$max = other.getMax();
        return !(this$max == null ? other$max != null : !this$max.equals(other$max));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RangeValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Number $min = this.getMin();
        result = result * 59 + ($min == null ? 43 : $min.hashCode());
        Number $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : $max.hashCode());
        return result;
    }
}

