/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import org.apache.zookeeper.common.PathTrie;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PathTrieTest {
    private PathTrie pathTrie;

    @BeforeEach
    public void before() {
        this.pathTrie = new PathTrie();
    }

    @Test
    public void addNullPath() {
        Assertions.assertThrows(NullPointerException.class, () -> this.pathTrie.addPath(null));
    }

    @Test
    public void addIllegalPath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.pathTrie.addPath(""));
    }

    @Test
    public void addPathToRoot() {
        this.pathTrie.addPath("node1");
        Assertions.assertTrue((boolean)this.pathTrie.existsNode("/node1"));
    }

    @Test
    public void addPathToRootLeaves() {
        this.pathTrie.addPath("node1");
        this.pathTrie.addPath("node1/node2");
        this.pathTrie.addPath("node1/node3");
        Assertions.assertTrue((boolean)this.pathTrie.existsNode("/node1"));
        Assertions.assertTrue((boolean)this.pathTrie.existsNode("/node1/node2"));
        Assertions.assertTrue((boolean)this.pathTrie.existsNode("/node1/node3"));
    }

    @Test
    public void deleteNullPath() {
        Assertions.assertThrows(NullPointerException.class, () -> this.pathTrie.deletePath(null));
    }

    @Test
    public void deleteIllegalPath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.pathTrie.deletePath(""));
    }

    @Test
    public void deletePathFromRoot() {
        this.pathTrie.addPath("node1");
        this.pathTrie.deletePath("node1");
        Assertions.assertFalse((boolean)this.pathTrie.existsNode("/node1"));
    }

    @Test
    public void deletePathFromRootLeaves() {
        this.pathTrie.addPath("node1");
        this.pathTrie.addPath("node1/node2");
        this.pathTrie.addPath("node1/node3");
        this.pathTrie.deletePath("node1/node3");
        Assertions.assertTrue((boolean)this.pathTrie.existsNode("/node1"));
        Assertions.assertTrue((boolean)this.pathTrie.existsNode("/node1/node2"));
        Assertions.assertFalse((boolean)this.pathTrie.existsNode("/node1/node3"));
        this.pathTrie.deletePath("node1/node2");
        Assertions.assertTrue((boolean)this.pathTrie.existsNode("/node1"));
        Assertions.assertFalse((boolean)this.pathTrie.existsNode("/node1/node2"));
        this.pathTrie.deletePath("node1");
        Assertions.assertFalse((boolean)this.pathTrie.existsNode("/node1"));
    }

    @Test
    public void deletePathDoesNotExist() {
        this.pathTrie.addPath("node1");
        this.pathTrie.addPath("node1/node2");
        this.pathTrie.deletePath("node1/node3");
        Assertions.assertTrue((boolean)this.pathTrie.existsNode("/node1"));
        Assertions.assertTrue((boolean)this.pathTrie.existsNode("/node1/node2"));
    }

    @Test
    public void deleteRootPath() {
        this.pathTrie.addPath("node1");
        this.pathTrie.addPath("node1/node2");
        this.pathTrie.addPath("node1/node3");
        this.pathTrie.deletePath("node1");
        Assertions.assertTrue((boolean)this.pathTrie.existsNode("/node1"));
        Assertions.assertTrue((boolean)this.pathTrie.existsNode("/node1/node2"));
        Assertions.assertTrue((boolean)this.pathTrie.existsNode("/node1/node3"));
    }

    @Test
    public void findMaxPrefixNullPath() {
        Assertions.assertThrows(NullPointerException.class, () -> this.pathTrie.findMaxPrefix(null));
    }

    @Test
    public void findMaxPrefixRootPath() {
        Assertions.assertEquals((Object)"/", (Object)this.pathTrie.findMaxPrefix("/"));
    }

    @Test
    public void findMaxPrefixChildren() {
        this.pathTrie.addPath("node1");
        this.pathTrie.addPath("node1/node2");
        this.pathTrie.addPath("node1/node3");
        Assertions.assertEquals((Object)"/node1", (Object)this.pathTrie.findMaxPrefix("/node1"));
        Assertions.assertEquals((Object)"/node1/node2", (Object)this.pathTrie.findMaxPrefix("/node1/node2"));
        Assertions.assertEquals((Object)"/node1/node3", (Object)this.pathTrie.findMaxPrefix("/node1/node3"));
    }

    @Test
    public void findMaxPrefixChildrenPrefix() {
        this.pathTrie.addPath("node1");
        Assertions.assertEquals((Object)"/node1", (Object)this.pathTrie.findMaxPrefix("/node1/node2"));
        Assertions.assertEquals((Object)"/node1", (Object)this.pathTrie.findMaxPrefix("/node1/node3"));
    }
}

