/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import org.apache.zookeeper.ClientCnxnSocketNIO;
import org.apache.zookeeper.ClientCnxnSocketNetty;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.test.TestByteBufAllocator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientCnxnSocketTest {
    @BeforeEach
    public void setUp() {
        ClientCnxnSocketNetty.setTestAllocator((ByteBufAllocator)TestByteBufAllocator.getInstance());
    }

    @AfterEach
    public void tearDown() {
        ClientCnxnSocketNetty.clearTestAllocator();
        TestByteBufAllocator.checkForLeaks();
    }

    @Test
    public void testWhenInvalidJuteMaxBufferIsConfiguredIOExceptionIsThrown() {
        ZKClientConfig clientConfig = new ZKClientConfig();
        String value = "SomeInvalidInt";
        clientConfig.setProperty("jute.maxbuffer", value);
        try {
            new ClientCnxnSocketNIO(clientConfig);
            Assertions.fail((String)"IOException is expected.");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains(value));
        }
        try {
            new ClientCnxnSocketNetty(clientConfig);
            Assertions.fail((String)"IOException is expected.");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains(value));
        }
    }

    @Test
    public void testIOExceptionIsThrownWhenPacketLenExceedsJuteMaxBuffer() throws IOException {
        ClientCnxnSocketNIO clientCnxnSocket = new ClientCnxnSocketNIO(new ZKClientConfig());
        int length = 1048575;
        clientCnxnSocket.incomingBuffer.putInt(length);
        clientCnxnSocket.incomingBuffer.rewind();
        clientCnxnSocket.readLength();
        length = 0x100000;
        clientCnxnSocket.incomingBuffer.putInt(length);
        clientCnxnSocket.incomingBuffer.rewind();
        try {
            clientCnxnSocket.readLength();
            Assertions.fail((String)"IOException is expected.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)("Packet len " + length + " is out of range!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testClientCanBeClosedWhenNotInitialized() throws IOException {
        ZKClientConfig clientConfig = new ZKClientConfig();
        ClientCnxnSocketNetty clientCnxnSocket = new ClientCnxnSocketNetty(clientConfig);
        clientCnxnSocket.close();
        clientCnxnSocket.onClosing();
    }
}

